/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Profiler {
    private final List sectionList = new ArrayList();
    private final List timestampList = new ArrayList();
    public boolean profilingEnabled;
    private String profilingSection = "";
    private final Map profilingMap = new HashMap();
    private static final String __OBFID = "CL_00001497";

    public void clearProfiling() {
        this.profilingMap.clear();
        this.profilingSection = "";
        this.sectionList.clear();
    }

    public void startSection(String par1Str) {
        if (this.profilingEnabled) {
            if (this.profilingSection.length() > 0) {
                this.profilingSection = this.profilingSection + ".";
            }
            this.profilingSection = this.profilingSection + par1Str;
            this.sectionList.add(this.profilingSection);
            this.timestampList.add(System.nanoTime());
        }
    }

    public void endSection() {
        if (this.profilingEnabled) {
            long var1 = System.nanoTime();
            long var3 = (Long)this.timestampList.remove(this.timestampList.size() - 1);
            this.sectionList.remove(this.sectionList.size() - 1);
            long var5 = var1 - var3;
            if (this.profilingMap.containsKey(this.profilingSection)) {
                this.profilingMap.put(this.profilingSection, (Long)this.profilingMap.get(this.profilingSection) + var5);
            } else {
                this.profilingMap.put(this.profilingSection, var5);
            }
            if (var5 > 100000000L) {
                System.out.println("Something's taking too long! '" + this.profilingSection + "' took aprox " + (double)var5 / 1000000.0 + " ms");
            }
            this.profilingSection = !this.sectionList.isEmpty() ? (String)this.sectionList.get(this.sectionList.size() - 1) : "";
        }
    }

    public List getProfilingData(String par1Str) {
        if (!this.profilingEnabled) {
            return null;
        }
        long var3 = this.profilingMap.containsKey("root") ? (Long)this.profilingMap.get("root") : 0L;
        long var5 = this.profilingMap.containsKey(par1Str) ? (Long)this.profilingMap.get(par1Str) : -1L;
        ArrayList<Result> var7 = new ArrayList<Result>();
        if (par1Str.length() > 0) {
            par1Str = par1Str + ".";
        }
        long var8 = 0L;
        for (String var11 : this.profilingMap.keySet()) {
            if (var11.length() <= par1Str.length() || !var11.startsWith(par1Str) || var11.indexOf(".", par1Str.length() + 1) >= 0) continue;
            var8 += ((Long)this.profilingMap.get(var11)).longValue();
        }
        float var20 = var8;
        if (var8 < var5) {
            var8 = var5;
        }
        if (var3 < var8) {
            var3 = var8;
        }
        for (String var12 : this.profilingMap.keySet()) {
            if (var12.length() <= par1Str.length() || !var12.startsWith(par1Str) || var12.indexOf(".", par1Str.length() + 1) >= 0) continue;
            long var13 = (Long)this.profilingMap.get(var12);
            double var15 = (double)var13 * 100.0 / (double)var8;
            double var17 = (double)var13 * 100.0 / (double)var3;
            String var19 = var12.substring(par1Str.length());
            var7.add(new Result(var19, var15, var17));
        }
        for (String var12 : this.profilingMap.keySet()) {
            this.profilingMap.put(var12, (Long)this.profilingMap.get(var12) * 999L / 1000L);
        }
        if ((float)var8 > var20) {
            var7.add(new Result("unspecified", (double)((float)var8 - var20) * 100.0 / (double)var8, (double)((float)var8 - var20) * 100.0 / (double)var3));
        }
        Collections.sort(var7);
        var7.add(0, new Result(par1Str, 100.0, (double)var8 * 100.0 / (double)var3));
        return var7;
    }

    public void endStartSection(String par1Str) {
        this.endSection();
        this.startSection(par1Str);
    }

    public String getNameOfLastSection() {
        return this.sectionList.size() == 0 ? "[UNKNOWN]" : (String)this.sectionList.get(this.sectionList.size() - 1);
    }

    public static final class Result
    implements Comparable {
        public double field_76332_a;
        public double field_76330_b;
        public String field_76331_c;
        private static final String __OBFID = "CL_00001498";

        public Result(String par1Str, double par2, double par4) {
            this.field_76331_c = par1Str;
            this.field_76332_a = par2;
            this.field_76330_b = par4;
        }

        public int compareTo(Result par1ProfilerResult) {
            return par1ProfilerResult.field_76332_a < this.field_76332_a ? -1 : (par1ProfilerResult.field_76332_a > this.field_76332_a ? 1 : par1ProfilerResult.field_76331_c.compareTo(this.field_76331_c));
        }

        public int func_76329_a() {
            return (this.field_76331_c.hashCode() & 0xAAAAAA) + 0x444444;
        }

        public int compareTo(Object par1Obj) {
            return this.compareTo((Result)par1Obj);
        }
    }
}

