/*
 * Decompiled with CFR 0.152.
 */
package net.ScarlxtPink.cust.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkinFix {
    private static final Map<String, String> uuids = new HashMap<String, String>();
    private static final Map<String, UserSkin> savedSkins = new HashMap<String, UserSkin>();
    private static final Gson gson = new Gson();
    public static boolean connected = false;
    public static String[] capeList = new String[]{"https://crafatar.com/capes/%UUID%", "http://s.optifine.net/capes/%NAME%"};
    static UserSkin skin1;

    public static Boolean isSkinAlex(String name) {
        UserSkin userSkin = SkinFix.getUserSkin(name);
        if (userSkin == null) {
            return false;
        }
        return userSkin.slim;
    }

    public static UserSkin getUserSkin(String playerName) {
        if (playerName == null) {
            return null;
        }
        if (savedSkins.containsKey(playerName)) {
            return savedSkins.get(playerName);
        }
        String uuid = SkinFix.getUuidStringFromName(playerName);
        if (uuid == null) {
            savedSkins.put(playerName, new UserSkin(null, null, false));
            return null;
        }
        String s2 = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=true";
        UserSkin userSkin = SkinFix.getSkinFromUrl(s2);
        savedSkins.put(playerName, userSkin);
        return userSkin;
    }

    private static boolean codeIs404(int code) {
        return code == 404 || code == 500;
    }

    private static boolean tryConnect(String urlS) {
        try {
            URL url = new URL(urlS);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            int code = connection.getResponseCode();
            if (!SkinFix.codeIs404(code)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static String getCapeUrl(String playerName) {
        String urlBase = "https://capes.johnymuffin.com/getCape.php?username=";
        String toSend = playerName;
        if (SkinFix.tryConnect(urlBase + toSend)) {
            return urlBase + toSend;
        }
        return null;
    }

    private static String getUuidStringFromName(String playerName) {
        if (uuids.containsKey(playerName)) {
            return uuids.get(playerName);
        }
        String uuid = SkinFix.getUuidFromMojang(playerName);
        if (uuid != null) {
            uuids.put(playerName, uuid);
        }
        return uuid;
    }

    private static JsonObject readJsonFromURL(String ur2) {
        try {
            String line;
            URL url = new URL(ur2);
            BufferedReader in2 = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder lines = new StringBuilder();
            while ((line = in2.readLine()) != null) {
                if (line.isEmpty()) continue;
                lines.append(line);
            }
            in2.close();
            return (JsonObject)gson.fromJson(lines.toString(), JsonObject.class);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static UserSkin getSkinFromUrl(String ur2) {
        skin1 = new UserSkin(null, null, false);
        skinThread getskin = new skinThread(ur2);
        getskin.start();
        try {
            getskin.join();
        }
        catch (InterruptedException e2) {
            System.out.println("EXCEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE");
        }
        System.out.println("SKIN SKIN SKIN");
        String[] nicks = savedSkins.keySet().toArray(new String[0]);
        UserSkin[] saved = savedSkins.values().toArray(new UserSkin[0]);
        for (int i2 = 0; i2 < saved.length; ++i2) {
            System.out.println(nicks[i2] + "     " + saved[i2].slim);
        }
        return skin1;
    }

    private static String getUuidFromMojang(String playerName) {
        try {
            String line;
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
            BufferedReader in2 = new BufferedReader(new InputStreamReader(url.openStream()));
            Pattern pattern = Pattern.compile("([0-9a-f]{32})");
            String uuidString = null;
            while ((line = in2.readLine()) != null && uuidString == null) {
                Matcher matcher;
                if (line.isEmpty() || !(matcher = pattern.matcher(line)).find()) continue;
                uuidString = matcher.group(1);
            }
            in2.close();
            return uuidString;
        }
        catch (IOException var7) {
            return null;
        }
    }

    public static class UserSkin {
        public final boolean slim;
        public final String skinUrl;
        private final String capeUrl;

        UserSkin(String skinUrl, String capeUrl, boolean slim) {
            this.slim = slim;
            this.skinUrl = skinUrl;
            this.capeUrl = capeUrl;
        }
    }

    private static class skinThread
    extends Thread {
        String uri;

        skinThread(String ur2) {
            this.uri = ur2;
        }

        @Override
        public void run() {
            JsonObject json = SkinFix.readJsonFromURL(this.uri);
            if (json == null) {
                skin1 = new UserSkin(null, null, false);
                System.out.println("AAAAAAAAAAA1");
                this.interrupt();
            }
            if (json.get("properties") != null) {
                String alex;
                JsonObject properties = ((JsonArray)json.get("properties")).get(0).getAsJsonObject();
                String value = properties.get("value").getAsString();
                String toJson = new String(Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8)));
                JsonObject user = (JsonObject)gson.fromJson(toJson, JsonObject.class);
                JsonObject textures = user.get("textures").getAsJsonObject();
                if (textures == null || textures.get("SKIN") == null) {
                    skin1 = new UserSkin(null, null, false);
                    System.out.println("AAAAAAAAAAA2");
                    this.interrupt();
                }
                JsonObject skin = textures.get("SKIN").getAsJsonObject();
                String capeUrl = null;
                if (textures.get("CAPE") != null) {
                    capeUrl = textures.get("CAPE").getAsJsonObject().get("url").getAsString();
                }
                String skinUrl = skin.get("url").getAsString();
                System.out.println("Got skin url: " + skinUrl);
                if (skin.get("metadata") != null && (alex = skin.get("metadata").getAsJsonObject().get("model").getAsString()).equalsIgnoreCase("slim")) {
                    System.out.println("AAAAAAAAAAA3");
                    skin1 = new UserSkin(skinUrl, capeUrl, true);
                    this.interrupt();
                }
                skin1 = new UserSkin(skinUrl, capeUrl, false);
                System.out.println("AAAAAAAAAAA4");
                this.interrupt();
            }
            skin1 = new UserSkin(null, null, false);
            System.out.println("AAAAAAAAAAA5");
        }
    }
}

