/*
 * Decompiled with CFR 0.152.
 */
package com.seven.Gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.lwjgl.opengl.GL20;

public class GLSLSandboxShader {
    private final int programId;
    private final int timeUniform;
    private final int mouseUniform;
    private final int resolutionUniform;
    private String menushader = "#define M_PI 3.1415926535897932384626433832795\r\n\r\nuniform float time;\r\nuniform vec2 resolution;\r\n\r\nfloat rand (in vec2 uv) { return fract(sin(dot(uv,vec2(12.4124,48.4124)))*48512.41241); }\r\nconst vec2 O = vec2(2.,1.);\r\nfloat noise (in vec2 uv) {\r\n\tvec2 b = floor(uv);\r\n\treturn mix(mix(rand(b),rand(b+O.yx),.5),mix(rand(b+O),rand(b+O.yy),.5),.5);\r\n}\r\n\r\nmat4 rotationMatrix(vec3 axis, float angle) {\r\n    axis = normalize(axis);\r\n    float s = sin(angle);\r\n    float c = cos(angle);\r\n    float oc = 1.0 - c;\r\n    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,\r\n                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,\r\n                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,\r\n                0.0,                                0.0,                                0.0,                                1.0);\r\n}\r\n\r\nvec4 stars(in vec2 p) {\r\n\tvec2 c = p - vec2(0.25, 0.5);\r\n\t\r\n\tconst int layers = 3;\r\n    \tvec2 size = vec2(resolution.x / resolution.y, 1.);\r\n\t\r\n\t\r\n\tvec2 uv = p*size;\r\n\t\r\n\tfloat stars = 0.;\r\n\tfloat fl=0., s=0.;\r\n\tfor (int layer = 0; layer < layers; layer++) {\r\n\t\tfl = float(layer);\r\n\t\ts = (300.-fl*30.);\r\n\t\tstars += smoothstep(0.0, 0.1,pow(noise(mod(vec2(uv.x*s - fl*100.,uv.y*s),resolution.x)),18.)) * (fl/float(layers));\r\n\t}\r\n\treturn vec4( vec3(stars), 1.0 );\r\n}\r\n\r\n\r\nvoid main()\r\n{\t\r\n\tfloat pitch = 0.;\r\n\tfloat yaw = 0.;\r\n\tvec4 col = vec4(0.044,0.036,0.063,1);\r\n    \tvec2 p = gl_FragCoord.xy / resolution.xy;\r\n\t\r\n\tvec4 dir = normalize(vec4( -p, 2., 0));\r\n\r\n\tfloat sb = sin(pitch);\r\n\tfloat cb = cos(pitch);\r\n\tdir = normalize(vec4(dir.x, dir.y * cb - dir.z * sb, dir.y * sb + dir.z * cb, 0));\r\n\t\r\n\tfloat sa = sin(-yaw);\r\n\tfloat ca = cos(-yaw);\r\n\tdir = normalize(vec4(dir.z * sa + dir.x * ca, dir.y, dir.z * ca - dir.x * sa, 0));\r\n\t\r\n\tvec4 ray;\r\n\t\r\n\tfor (int i=0; i<16; i++) {\r\n\t\tfloat mult = 16.-float(i);\r\n\t\r\n\t\tfloat j = float(i) + 7.;\r\n\t\tfloat rand1 = (j * j * 4321. + j * 8.) * 2.0;\r\n\t\tfloat k = j + 1.;\r\n\t\tfloat rand2 = (k * k * k * 239. + k * 37.) * 3.6;\r\n\t\tfloat rand3 = rand1 * 347.4 + rand2 * 63.4;\r\n\t\t\r\n\t\tvec3 axis = normalize(vec3(sin(rand1), sin(rand2) , cos(rand3)));\r\n\t\t\r\n\t\tray = dir * rotationMatrix(axis, mod(rand3, 2.*M_PI));\r\n\t\t\r\n\t\tfloat u = 0.5 + (atan(ray.z,ray.x)/(2.*M_PI));\r\n\t\tfloat v = 0.5 + (asin(ray.y)/M_PI);\r\n\t\t\r\n\t\tfloat scale = mult*0.5 + 2.75;\r\n\t\tvec2 tex = vec2( u * scale, (v + time * 0.0006) * scale * .6 );\r\n\t\t\r\n\t\tvec4 tcol = stars(tex);\r\n\t\t\r\n\t\tfloat a = tcol.r * (0.05 + (1.0/mult) * 0.65) * (1.-smoothstep(0.15, 0.48, abs(v-0.25)));\r\n\t\t\r\n\t\tfloat r = (mod(rand1, 29.0)/29.0) * 0.5 + 0.1;\r\n    \t\tfloat g = (mod(rand2, 35.0)/35.0) * 0.5 + 0.4;\r\n    \t\tfloat b = (mod(rand1, 17.0)/17.0) * 0.5 + 0.5;\r\n\t\t\r\n\t\tcol = col*(1.-a) + vec4(r,g,b,1.)*a;\r\n\t}\r\n    \r\n    \tgl_FragColor = col;\r\n}";
    private String creditsshader = "uniform float time;\nuniform vec2 mouse;\nuniform vec2 resolution;\n\nfloat hash12(vec2 p)\n{\n\tvec3 p3  = fract(vec3(p.xyx) * .1031);\n    p3 += dot(p3, p3.yzx + 33.33);\n    return fract((p3.x + p3.y) * p3.z);\n}\n\n//----------------------------------------------------------------------------------------\n//  2 out, 1 in...\nvec2 hash21(float p)\n{\n\tvec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));\n\tp3 += dot(p3, p3.yzx + 33.33);\n    return fract((p3.xx+p3.yz)*p3.zy);\n\n}\nfloat noise(vec2 p)\n{\n    vec2 ip = floor(p), fp = fract(p);\n    fp = smoothstep(0.,1.,fp);\n    return mix(\n               mix(hash12(ip+vec2(0,0)), hash12(ip+vec2(1,0)), fp.x),\n               mix(hash12(ip+vec2(0,1)), hash12(ip+vec2(1,1)), fp.x),\n               fp.y);\n}\n\nfloat fbm(vec2 p, int lv)\n{\n    float a = 1.0;\n    float t = 0.0;\n    for( int i=0; i<8; i++ )\n    {\n        p += vec2(13.102,1.535);\n        t += a*noise(p);\n        p *= mat2(3,4,-4,3) * 0.4;\n        a *= 0.5;\n    }\n    return 0.5*t;\n}\n\nvoid main( )\n{\n    vec2 uv = (2.*gl_FragCoord.xy-resolution.xy)/resolution.y;\n    \n    float mtHeight = fbm(uv.xx+0.6, 8);\n    float mtHeightSm = fbm(uv.xx+0.6, 3);\n    vec3 col = vec3(0);\n    vec2 sunPos = vec2(0.8,-0.);\n    vec3 skyCol = vec3(0.075,0.310,0.518);\n    float q = uv.y-sunPos.y;\n    float q2 = uv.x-sunPos.x;\n    skyCol = mix(skyCol, vec3(0.482,0.580,0.902), exp(-0.5*q*q-0.2*q2*q2));\n    vec3 cloudCol = mix(skyCol, vec3(0.5), 0.2);\n    skyCol = mix(skyCol, vec3(0.706,0.851,0.953), exp(-q*q*3.-0.5*q2*q2));\n    skyCol = mix(skyCol, vec3(0.980,0.5,0.3), exp(-q*q*10.-0.5*q2*q2));\n    skyCol = mix(skyCol, vec3(1.0,1.0,0.7), exp(-3.*length(uv-sunPos)));\n    vec3 cloudCol2 = mix(skyCol, vec3(0.5), 0.2);\n    vec3 cloudCol3 = mix(vec3(0.980,0.5,0.3),vec3(1.0,1.0,0.7), exp(-length(uv-sunPos)));\n    cloudCol3 = mix(cloudCol3, cloudCol, smoothstep(0.,-1.,uv.y+0.3*uv.x));\n    \n    float w = 1.5*length(fwidth(uv));\n    float isSky = smoothstep(0.,w,uv.y+0.3*uv.x+0.2*max(uv.x,0.)+1.-mtHeight);\n   \n\tcol = mix(col, skyCol, isSky);\n    col = mix(col, skyCol, 0.5*smoothstep(-0.5,0.1,uv.y+0.3*uv.x+0.2*max(uv.x,0.)+1.-mtHeightSm));\n    \n    vec2 fuv = fract(0.1*uv);\n    vec2 uvv = 20.*fuv*(1.-fuv)*(0.5-fuv);\n    uvv = vec2(1,-1)*uvv.yx;\n    vec2 uv2 = uv + uvv*cos(0.4*time);// twisting\n    \n    float silver = fbm(30.*uv - 0.06*time, 8) + 30.*(uv.y + 0.8);\n    silver = smoothstep(0.,1.,silver)*smoothstep(2.,1.,silver) * 1./(1.+500.*q2*q2) * isSky;\n    col += silver * vec3(0.9,0.6,0.3) * 100.;\n    \n    \n    float lowClouds = fbm(5.*uv + 0.1*time, 8);\n    float midClouds = fbm(3.*uv + vec2(0.06,-0.03)*time, 8);\n    float hiClouds = fbm(uv2 + vec2(0.1,0.01)*time, 8) - 0.5;\n    float hiClouds2 = fbm(uv + 10. + vec2(0.062,-0.03)*time, 8) - 0.5;\n    col = mix(col, cloudCol3, 0.5*smoothstep(0.,1., -uv.y+3.*hiClouds));\n    col = mix(col, cloudCol3, 0.5*smoothstep(0.,1., -uv.y+3.*hiClouds2));\n    col = mix(col, vec3(0.9,0.6,0.3) * 100., 1./(1.+2000.*(q*q+q2*q2)));\n    col += vec3(0.9,0.6,0.3) * 2./(1.+10.*sqrt(q*q+0.3*q2*q2));\n    col = mix(col, 0.8*cloudCol, 0.8*smoothstep(0.,1., -2.*(uv.y+0.5)+midClouds));\n    col = mix(col, 0.5*cloudCol, smoothstep(0.,1., -3.*(uv.y+0.8)+lowClouds));\n    \n    \n    col = mix(col, col*pow(col/(col.r+col.g+col.b), vec3(dot(uv,uv)*0.3)), 0.2); // vignette\n    col = pow(col, vec3(2.2));\n    col = (col*(2.51*col+0.03))/(col*(2.43*col+0.59)+0.14); // tonemapping\n    col = pow(col, vec3(1./2.2));\n    \n    col += 0.03 * (hash12(gl_FragCoord.xy)-0.5) * sqrt(resolution.y/400.);\n\n    // Output to screen\n    gl_FragColor = vec4(col,1.0);\n}";

    public GLSLSandboxShader(String s2) throws IOException {
        int program = GL20.glCreateProgram();
        GL20.glAttachShader((int)program, (int)this.createShaderPass(35633));
        GL20.glAttachShader((int)program, (int)this.createShader(35632, s2));
        GL20.glLinkProgram((int)program);
        int linked = GL20.glGetProgrami((int)program, (int)35714);
        if (linked == 0) {
            System.err.println(GL20.glGetProgramInfoLog((int)program, (int)GL20.glGetProgrami((int)program, (int)35716)));
            throw new IllegalStateException("Shader failed to link");
        }
        this.programId = program;
        GL20.glUseProgram((int)program);
        this.timeUniform = GL20.glGetUniformLocation((int)program, (CharSequence)"time");
        this.mouseUniform = GL20.glGetUniformLocation((int)program, (CharSequence)"mouse");
        this.resolutionUniform = GL20.glGetUniformLocation((int)program, (CharSequence)"resolution");
        GL20.glUseProgram((int)0);
    }

    public void useShader(int width, int height, float mouseX, float mouseY, float time) {
        GL20.glUseProgram((int)this.programId);
        GL20.glUniform2f((int)this.resolutionUniform, (float)width, (float)height);
        GL20.glUniform2f((int)this.mouseUniform, (float)(mouseX / (float)width), (float)(1.0f - mouseY / (float)height));
        GL20.glUniform1f((int)this.timeUniform, (float)time);
    }

    private int createShader(int shaderType, String s2) throws IOException {
        int shader = GL20.glCreateShader((int)shaderType);
        String shad = null;
        switch (s2) {
            case "menu": {
                shad = this.menushader;
                break;
            }
            case "credits": {
                shad = this.creditsshader;
            }
        }
        GL20.glShaderSource((int)shader, (CharSequence)shad);
        GL20.glCompileShader((int)shader);
        int compiled = GL20.glGetShaderi((int)shader, (int)35713);
        if (compiled == 0) {
            System.err.println(GL20.glGetShaderInfoLog((int)shader, (int)GL20.glGetShaderi((int)shader, (int)35716)));
            throw new RuntimeException("Failed to compile shader");
        }
        return shader;
    }

    private int createShaderPass(int shaderType) throws IOException {
        int shader = GL20.glCreateShader((int)shaderType);
        GL20.glShaderSource((int)shader, (CharSequence)"#version 120\r\n\r\nvoid main() {\r\n    gl_Position = gl_Vertex;\r\n}");
        GL20.glCompileShader((int)shader);
        int compiled = GL20.glGetShaderi((int)shader, (int)35713);
        if (compiled == 0) {
            System.err.println(GL20.glGetShaderInfoLog((int)shader, (int)GL20.glGetShaderi((int)shader, (int)35716)));
            throw new RuntimeException("Failed to compile shader");
        }
        return shader;
    }

    private String readStreamToString(InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((read = inputStream.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, read);
        }
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }
}

