/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.CustomAnimation;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public class TextureUtils {
    public static Minecraft minecraft;
    private static boolean animatedFire;
    private static boolean animatedLava;
    private static boolean animatedWater;
    private static boolean animatedPortal;
    private static boolean customFire;
    private static boolean customLava;
    private static boolean customWater;
    private static boolean customPortal;
    public static final int LAVA_STILL_TEXTURE_INDEX = 237;
    public static final int LAVA_FLOWING_TEXTURE_INDEX = 238;
    public static final int WATER_STILL_TEXTURE_INDEX = 205;
    public static final int WATER_FLOWING_TEXTURE_INDEX = 206;
    public static final int FIRE_E_W_TEXTURE_INDEX = 31;
    public static final int FIRE_N_S_TEXTURE_INDEX = 47;
    public static final int PORTAL_TEXTURE_INDEX = 14;
    private static HashMap expectedColumns;
    private static boolean useTextureCache;
    private static i lastTexturePack;
    private static HashMap cache;

    public static boolean setTileSize() {
        MCPatcherUtils.log("\nchanging skin to %s", new Object[]{TextureUtils.getTexturePackName(TextureUtils.getSelectedTexturePack())});
        int i2 = TextureUtils.getTileSize();
        if (i2 == TileSize.int_size) {
            MCPatcherUtils.log("tile size %d unchanged", new Object[]{i2});
            return false;
        }
        MCPatcherUtils.log("setting tile size to %d (was %d)", new Object[]{i2, TileSize.int_size});
        TileSize.setTileSize(i2);
        return true;
    }

    public static void setFontRenderer() {
        MCPatcherUtils.log("setFontRenderer()", new Object[0]);
        TextureUtils.minecraft.q.initialize(TextureUtils.minecraft.z, "/font/default.png", TextureUtils.minecraft.p);
    }

    public static void registerTextureFX(List list, aw texturefx) {
        aw texturefx1 = TextureUtils.refreshTextureFX(texturefx);
        if (texturefx1 != null) {
            MCPatcherUtils.log("registering new TextureFX class %s", new Object[]{texturefx.getClass().getName()});
            list.add(texturefx1);
            texturefx1.a();
        }
    }

    private static aw refreshTextureFX(aw texturefx) {
        if (texturefx instanceof av || texturefx instanceof ku || texturefx instanceof cg || texturefx instanceof if || texturefx instanceof vs || texturefx instanceof oh || texturefx instanceof sd || texturefx instanceof hs || texturefx instanceof CustomAnimation) {
            return null;
        }
        Class<?> class1 = texturefx.getClass();
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                switch (i2) {
                    case 0: {
                        Constructor<?> constructor = class1.getConstructor(Minecraft.class, Integer.TYPE);
                        return (aw)constructor.newInstance(minecraft, TileSize.int_size);
                    }
                    case 1: {
                        Constructor<?> constructor1 = class1.getConstructor(Minecraft.class);
                        return (aw)constructor1.newInstance(minecraft);
                    }
                    case 2: {
                        Constructor<?> constructor2 = class1.getConstructor(new Class[0]);
                        return (aw)constructor2.newInstance(new Object[0]);
                    }
                }
                continue;
            }
            catch (NoSuchMethodException constructor) {
                continue;
            }
            catch (IllegalAccessException constructor) {
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (texturefx.a.length != TileSize.int_numBytes) {
            MCPatcherUtils.log("resizing %s buffer from %d to %d bytes", new Object[]{class1.getName(), texturefx.a.length, TileSize.int_numBytes});
            texturefx.a = new byte[TileSize.int_numBytes];
        }
        return texturefx;
    }

    public static void refreshTextureFX(List list) {
        boolean flag;
        MCPatcherUtils.log("refreshTextureFX()", new Object[0]);
        ArrayList<aw> arraylist = new ArrayList<aw>();
        for (aw texturefx : list) {
            aw texturefx1 = TextureUtils.refreshTextureFX(texturefx);
            if (texturefx1 == null) continue;
            arraylist.add(texturefx1);
        }
        list.clear();
        list.add(new av(minecraft));
        list.add(new ku(minecraft));
        i obj = TextureUtils.getSelectedTexturePack();
        boolean bl2 = flag = obj == null || obj instanceof pa;
        if (!flag && customLava) {
            list.add(new CustomAnimation(237, 0, 1, "lava_still", -1, -1));
            list.add(new CustomAnimation(238, 0, 2, "lava_flowing", 3, 6));
        } else if (animatedLava) {
            list.add(new cg());
            list.add(new if());
        }
        if (!flag && customWater) {
            list.add(new CustomAnimation(205, 0, 1, "water_still", -1, -1));
            list.add(new CustomAnimation(206, 0, 2, "water_flowing", 0, 0));
        } else if (animatedWater) {
            list.add(new vs());
            list.add(new oh());
        }
        if (!flag && customFire && TextureUtils.hasResource("/custom_fire_e_w.png") && TextureUtils.hasResource("/custom_fire_n_s.png")) {
            list.add(new CustomAnimation(47, 0, 1, "fire_n_s", 2, 4));
            list.add(new CustomAnimation(31, 0, 1, "fire_e_w", 2, 4));
        } else if (animatedFire) {
            list.add(new sd(0));
            list.add(new sd(1));
        }
        if (!flag && customPortal && TextureUtils.hasResource("/custom_portal.png")) {
            list.add(new CustomAnimation(14, 0, 1, "portal", -1, -1));
        } else if (animatedPortal) {
            list.add(new hs());
        }
        for (aw texturefx2 : arraylist) {
            list.add(texturefx2);
        }
        for (aw texturefx3 : list) {
            texturefx3.a();
        }
        if (hw.a != jh.a) {
            TextureUtils.refreshColorizer(hw.a, "/misc/watercolor.png");
        }
        TextureUtils.refreshColorizer(ia.a, "/misc/grasscolor.png");
        TextureUtils.refreshColorizer(jh.a, "/misc/foliagecolor.png");
        System.gc();
    }

    public static i getSelectedTexturePack() {
        return minecraft != null ? (TextureUtils.minecraft.D != null ? TextureUtils.minecraft.D.a : null) : null;
    }

    public static String getTexturePackName(i texturepackbase) {
        return texturepackbase != null ? texturepackbase.a : "Default";
    }

    public static ByteBuffer getByteBuffer(ByteBuffer bytebuffer, byte[] abyte0) {
        bytebuffer.clear();
        int i2 = bytebuffer.capacity();
        int j2 = abyte0.length;
        if (j2 > i2 || i2 >= 4 * j2) {
            MCPatcherUtils.log("resizing gl buffer from 0x%x to 0x%x", new Object[]{i2, j2});
            bytebuffer = ge.c(j2);
        }
        bytebuffer.put(abyte0);
        bytebuffer.position(0).limit(j2);
        TileSize.int_glBufferSize = j2;
        return bytebuffer;
    }

    public static InputStream getResourceAsStream(i texturepackbase, String s2) {
        InputStream inputstream = null;
        if (texturepackbase != null) {
            try {
                inputstream = texturepackbase.a(s2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (inputstream == null) {
            inputstream = TextureUtils.class.getResourceAsStream(s2);
        }
        if (inputstream == null && !s2.startsWith("/custom_")) {
            inputstream = Thread.currentThread().getContextClassLoader().getResourceAsStream(s2);
            MCPatcherUtils.warn("falling back on thread class loader for %s: %s", new Object[]{s2, inputstream != null ? "success" : "failed"});
        }
        return inputstream;
    }

    public static InputStream getResourceAsStream(String s2) {
        return TextureUtils.getResourceAsStream(TextureUtils.getSelectedTexturePack(), s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getResourceAsBufferedImage(i texturepackbase, String s2) throws IOException {
        InputStream inputstream;
        BufferedImage bufferedimage = null;
        boolean flag = false;
        if (useTextureCache && texturepackbase == lastTexturePack && (bufferedimage = (BufferedImage)cache.get(s2)) != null) {
            flag = true;
        }
        if (bufferedimage == null && (inputstream = TextureUtils.getResourceAsStream(texturepackbase, s2)) != null) {
            try {
                bufferedimage = ImageIO.read(inputstream);
            }
            finally {
                MCPatcherUtils.close(inputstream);
            }
        }
        if (bufferedimage == null) {
            throw new IOException(s2 + " image is null");
        }
        if (useTextureCache && !flag && texturepackbase != lastTexturePack) {
            MCPatcherUtils.log("clearing texture cache (%d items)", new Object[]{cache.size()});
            cache.clear();
        }
        MCPatcherUtils.log("opened %s %dx%d from %s", new Object[]{s2, bufferedimage.getWidth(), bufferedimage.getHeight(), flag ? "cache" : TextureUtils.getTexturePackName(texturepackbase)});
        if (!flag) {
            Integer integer = (Integer)expectedColumns.get(s2);
            if (integer != null && bufferedimage.getWidth() != integer * TileSize.int_size) {
                bufferedimage = TextureUtils.resizeImage(bufferedimage, integer * TileSize.int_size);
            }
            if (useTextureCache) {
                lastTexturePack = texturepackbase;
                cache.put(s2, bufferedimage);
            }
        }
        return bufferedimage;
    }

    public static BufferedImage getResourceAsBufferedImage(String s2) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(TextureUtils.getSelectedTexturePack(), s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTileSize(i texturepackbase) {
        int i2 = 0;
        for (Map.Entry entry : expectedColumns.entrySet()) {
            InputStream inputstream = null;
            try {
                try {
                    inputstream = TextureUtils.getResourceAsStream(texturepackbase, (String)entry.getKey());
                    if (inputstream != null) {
                        BufferedImage bufferedimage = ImageIO.read(inputstream);
                        int j2 = bufferedimage.getWidth() / (Integer)entry.getValue();
                        MCPatcherUtils.log("  %s tile size is %d", new Object[]{entry.getKey(), j2});
                        i2 = Math.max(i2, j2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(inputstream);
                throw throwable;
            }
            MCPatcherUtils.close(inputstream);
        }
        return i2 <= 0 ? 16 : i2;
    }

    public static int getTileSize() {
        return TextureUtils.getTileSize(TextureUtils.getSelectedTexturePack());
    }

    public static boolean hasResource(i texturepackbase, String s2) {
        InputStream inputstream = TextureUtils.getResourceAsStream(texturepackbase, s2);
        boolean flag = inputstream != null;
        MCPatcherUtils.close(inputstream);
        return flag;
    }

    public static boolean hasResource(String s2) {
        return TextureUtils.hasResource(TextureUtils.getSelectedTexturePack(), s2);
    }

    private static BufferedImage resizeImage(BufferedImage bufferedimage, int i2) {
        int j2 = bufferedimage.getHeight() * i2 / bufferedimage.getWidth();
        MCPatcherUtils.log("  resizing to %dx%d", new Object[]{i2, j2});
        BufferedImage bufferedimage1 = new BufferedImage(i2, j2, 2);
        Graphics2D graphics2d = bufferedimage1.createGraphics();
        graphics2d.drawImage(bufferedimage, 0, 0, i2, j2, null);
        return bufferedimage1;
    }

    private static void refreshColorizer(int[] ai2, String s2) {
        try {
            BufferedImage bufferedimage = TextureUtils.getResourceAsBufferedImage(s2);
            if (bufferedimage != null) {
                bufferedimage.getRGB(0, 0, 256, 256, ai2, 0, 256);
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public static void setMinecraft(Minecraft minecraft1) {
        minecraft = minecraft1;
    }

    public static Minecraft getMinecraft() {
        return minecraft;
    }

    static {
        animatedFire = MCPatcherUtils.getBoolean("HD Textures", "animatedFire", true);
        animatedLava = MCPatcherUtils.getBoolean("HD Textures", "animatedLava", true);
        animatedWater = MCPatcherUtils.getBoolean("HD Textures", "animatedWater", true);
        animatedPortal = MCPatcherUtils.getBoolean("HD Textures", "animatedPortal", true);
        customFire = MCPatcherUtils.getBoolean("HD Textures", "customFire", true);
        customLava = MCPatcherUtils.getBoolean("HD Textures", "customLava", true);
        customWater = MCPatcherUtils.getBoolean("HD Textures", "customWater", true);
        customPortal = MCPatcherUtils.getBoolean("HD Textures", "customPortal", true);
        useTextureCache = MCPatcherUtils.getBoolean("HD Textures", "useTextureCache", false);
        lastTexturePack = null;
        cache = new HashMap();
        expectedColumns = new HashMap();
        expectedColumns.put("/terrain.png", 16);
        expectedColumns.put("/gui/items.png", 16);
        expectedColumns.put("/misc/dial.png", 1);
        expectedColumns.put("/custom_lava_still.png", 1);
        expectedColumns.put("/custom_lava_flowing.png", 1);
        expectedColumns.put("/custom_water_still.png", 1);
        expectedColumns.put("/custom_water_flowing.png", 1);
        expectedColumns.put("/custom_fire_n_s.png", 1);
        expectedColumns.put("/custom_fire_e_w.png", 1);
        expectedColumns.put("/custom_portal.png", 1);
    }
}

