/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.Config;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class MCPatcherUtils {
    private static File minecraftDir;
    private static boolean debug;
    private static boolean isGame;
    static Config config;
    public static final String HD_TEXTURES = "HD Textures";
    public static final String HD_FONT = "HD Font";
    public static final String BETTER_GRASS = "Better Grass";

    private MCPatcherUtils() {
    }

    static File getDefaultGameDir() {
        String s2 = System.getProperty("os.name").toLowerCase();
        String s1 = null;
        String s22 = ".minecraft";
        if (s2.contains("win")) {
            s1 = System.getenv("APPDATA");
        } else if (s2.contains("mac")) {
            s22 = "Library/Application Support/minecraft";
        }
        if (s1 == null) {
            s1 = System.getProperty("user.home");
        }
        return new File(s1, s22);
    }

    static boolean setGameDir(File file) {
        minecraftDir = file != null && file.isDirectory() && new File(file, "bin/lwjgl.jar").exists() && new File(file, "resources").isDirectory() ? file.getAbsoluteFile() : null;
        return MCPatcherUtils.loadProperties();
    }

    private static boolean loadProperties() {
        config = null;
        if (minecraftDir != null && minecraftDir.exists()) {
            try {
                config = new Config(minecraftDir);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            debug = MCPatcherUtils.getBoolean("debug", false);
            return true;
        }
        return false;
    }

    public static File getMinecraftPath(String[] as2) {
        File file = minecraftDir;
        for (String s2 : as2) {
            file = new File(file, s2);
        }
        return file;
    }

    public static void log(String s2, Object[] aobj) {
        if (debug) {
            System.out.printf(s2 + "\n", aobj);
        }
    }

    public static boolean isGame() {
        return isGame;
    }

    public static void warn(String s2, Object[] aobj) {
        System.out.printf("WARNING: " + s2 + "\n", aobj);
    }

    public static void error(String s2, Object[] aobj) {
        System.out.printf("ERROR: " + s2 + "\n", aobj);
    }

    public static String getString(String s2, String s1, Object obj) {
        if (config == null) {
            return obj != null ? obj.toString() : null;
        }
        String s22 = config.getModConfigValue(s2, s1);
        if (s22 == null && obj != null) {
            s22 = obj.toString();
            config.setModConfigValue(s2, s1, s22);
        }
        return s22;
    }

    public static String getString(String s2, Object obj) {
        if (config == null) {
            return obj != null ? obj.toString() : null;
        }
        String s1 = config.getConfigValue(s2);
        if (s1 == null && obj != null) {
            s1 = obj.toString();
            config.setConfigValue(s2, s1);
        }
        return s1;
    }

    public static int getInt(String s2, String s1, int i2) {
        int j2;
        try {
            j2 = Integer.parseInt(MCPatcherUtils.getString(s2, s1, i2));
        }
        catch (NumberFormatException numberformatexception) {
            j2 = i2;
        }
        return j2;
    }

    public static int getInt(String s2, int i2) {
        int j2;
        try {
            j2 = Integer.parseInt(MCPatcherUtils.getString(s2, i2));
        }
        catch (NumberFormatException numberformatexception) {
            j2 = i2;
        }
        return j2;
    }

    public static boolean getBoolean(String s2, String s1, boolean flag) {
        String s22 = MCPatcherUtils.getString(s2, s1, flag).toLowerCase();
        if (s22.equals("false")) {
            return false;
        }
        if (s22.equals("true")) {
            return true;
        }
        return flag;
    }

    public static boolean getBoolean(String s2, boolean flag) {
        String s1 = MCPatcherUtils.getString(s2, flag).toLowerCase();
        if (s1.equals("false")) {
            return false;
        }
        if (s1.equals("true")) {
            return true;
        }
        return flag;
    }

    public static void set(String s2, String s1, Object obj) {
        if (config != null) {
            config.setModConfigValue(s2, s1, obj.toString());
        }
    }

    static void set(String s2, Object obj) {
        if (config != null) {
            config.setConfigValue(s2, obj.toString());
        }
    }

    public static void remove(String s2, String s1) {
        if (config != null) {
            config.remove(config.getModConfig(s2, s1));
        }
    }

    static void remove(String s2) {
        if (config != null) {
            config.remove(config.getConfig(s2));
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    public static void close(ZipFile zipfile) {
        if (zipfile != null) {
            try {
                zipfile.close();
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    static {
        debug = false;
        config = null;
        minecraftDir = null;
        isGame = true;
        try {
            if (Class.forName("com.pclewis.com.pclewis.mcpatcher.MCPatcher") != null) {
                isGame = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (isGame) {
            if (MCPatcherUtils.setGameDir(new File(".")) || MCPatcherUtils.setGameDir(MCPatcherUtils.getDefaultGameDir())) {
                System.out.println("MCPatcherUtils initialized. Directory " + minecraftDir.getPath());
            } else {
                System.out.println("MCPatcherUtils initialized. Current directory " + new File(".").getAbsolutePath());
            }
        }
    }
}

