/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.MCPatcherUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Config {
    private File xmlFile = null;
    Document xml;
    static final String TAG_ROOT = "mcpatcherProfile";
    static final String TAG_CONFIG1 = "config";
    static final String TAG_DEBUG = "debug";
    static final String TAG_JAVA_HEAP_SIZE = "javaHeapSize";
    static final String TAG_LAST_VERSION = "lastVersion";
    static final String TAG_BETA_WARNING_SHOWN = "betaWarningShown";
    static final String TAG_MODS = "mods";
    static final String TAG_MOD = "mod";
    static final String TAG_NAME = "name";
    static final String TAG_TYPE = "type";
    static final String TAG_PATH = "path";
    static final String TAG_FILES = "files";
    static final String TAG_FILE = "file";
    static final String TAG_FROM = "from";
    static final String TAG_TO = "to";
    static final String TAG_CLASS = "class";
    static final String TAG_ENABLED = "enabled";
    static final String ATTR_VERSION = "version";
    static final String VAL_BUILTIN = "builtIn";
    static final String VAL_EXTERNAL_ZIP = "externalZip";
    static final String VAL_EXTERNAL_JAR = "externalJar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Config(File file) throws ParserConfigurationException {
        File file1;
        this.xmlFile = new File(file, "com.pclewis.mcpatcher.xml");
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
        boolean flag = false;
        if (this.xmlFile.exists()) {
            try {
                this.xml = documentbuilder.parse(this.xmlFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.xml == null) {
            this.xml = documentbuilder.newDocument();
            this.buildNewProperties();
            flag = true;
        }
        if ((file1 = new File(file, "com.pclewis.mcpatcher.properties")).exists()) {
            FileInputStream fileinputstream = null;
            try {
                fileinputstream = new FileInputStream(file1);
                this.convertPropertiesToXML(fileinputstream);
                flag = true;
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
            finally {
                if (fileinputstream != null) {
                    try {
                        fileinputstream.close();
                    }
                    catch (IOException ioexception) {
                        ioexception.printStackTrace();
                    }
                }
                file1.delete();
            }
        }
        if (flag) {
            this.saveProperties();
        }
    }

    private void convertPropertiesToXML(InputStream inputstream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputstream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String s2 = entry.getKey().toString();
            String s1 = entry.getValue().toString();
            if (s2.equals(TAG_DEBUG) || s2.equals(TAG_LAST_VERSION) || s2.equals(TAG_BETA_WARNING_SHOWN) || s2.equals(TAG_JAVA_HEAP_SIZE)) {
                MCPatcherUtils.set(s2, s1);
                continue;
            }
            if (!s2.startsWith("HDTexture.") || (s2 = s2.substring(10)).equals(TAG_ENABLED)) continue;
            MCPatcherUtils.set("HD Textures", s2, s1);
        }
    }

    Element getElement(Element element, String s2) {
        Element element1;
        if (element == null) {
            return null;
        }
        NodeList nodelist = element.getElementsByTagName(s2);
        if (nodelist.getLength() == 0) {
            element1 = this.xml.createElement(s2);
            element.appendChild(element1);
        } else {
            element1 = (Element)nodelist.item(0);
        }
        return element1;
    }

    String getText(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 3: {
                return ((Text)node).getData();
            }
            case 2: {
                return ((Attr)node).getValue();
            }
            case 1: {
                NodeList nodelist = node.getChildNodes();
                for (int i2 = 0; i2 < nodelist.getLength(); ++i2) {
                    Node node1 = nodelist.item(i2);
                    if (node1.getNodeType() != 3) continue;
                    return ((Text)node1).getData();
                }
                break;
            }
        }
        return null;
    }

    void setText(Element element, String s2, String s1) {
        if (element == null) {
            return;
        }
        Element element1 = this.getElement(element, s2);
        while (element1.hasChildNodes()) {
            element1.removeChild(element1.getFirstChild());
        }
        Text text = this.xml.createTextNode(s1);
        element1.appendChild(text);
    }

    void remove(Node node) {
        if (node != null) {
            Node node1 = node.getParentNode();
            node1.removeChild(node);
        }
    }

    String getText(Element element, String s2) {
        return this.getText(this.getElement(element, s2));
    }

    Element getRoot() {
        if (this.xml == null) {
            return null;
        }
        Element element = this.xml.getDocumentElement();
        if (element == null) {
            element = this.xml.createElement(TAG_ROOT);
            this.xml.appendChild(element);
        }
        return element;
    }

    Element getConfig() {
        return this.getElement(this.getRoot(), TAG_CONFIG1);
    }

    Element getConfig(String s2) {
        return this.getElement(this.getConfig(), s2);
    }

    String getConfigValue(String s2) {
        return this.getText(this.getConfig(s2));
    }

    void setConfigValue(String s2, String s1) {
        Element element = this.getConfig(s2);
        if (element != null) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            element.appendChild(this.xml.createTextNode(s1));
        }
    }

    Element getMods() {
        return this.getElement(this.getRoot(), TAG_MODS);
    }

    boolean hasMod(String s2) {
        Element element = this.getMods();
        if (element != null) {
            NodeList nodelist = element.getElementsByTagName(TAG_MOD);
            for (int i2 = 0; i2 < nodelist.getLength(); ++i2) {
                Element element1 = (Element)nodelist.item(i2);
                NodeList nodelist1 = element1.getElementsByTagName(TAG_NAME);
                if (nodelist1.getLength() <= 0 || !s2.equals(this.getText(element1 = (Element)nodelist1.item(0)))) continue;
                return true;
            }
        }
        return false;
    }

    Element getMod(String s2) {
        Element element = this.getMods();
        if (element == null) {
            return null;
        }
        NodeList nodelist = element.getElementsByTagName(TAG_MOD);
        for (int i2 = 0; i2 < nodelist.getLength(); ++i2) {
            Element element3;
            Node node = nodelist.item(i2);
            if (!(node instanceof Element) || !s2.equals(this.getText(element3 = (Element)node, TAG_NAME))) continue;
            return element3;
        }
        Element element1 = this.xml.createElement(TAG_MOD);
        element.appendChild(element1);
        Element element2 = this.xml.createElement(TAG_NAME);
        Text text = this.xml.createTextNode(s2);
        element2.appendChild(text);
        element1.appendChild(element2);
        element2 = this.xml.createElement(TAG_ENABLED);
        element1.appendChild(element2);
        element2 = this.xml.createElement(TAG_TYPE);
        element1.appendChild(element2);
        return element1;
    }

    void setModEnabled(String s2, boolean flag) {
        this.setText(this.getMod(s2), TAG_ENABLED, Boolean.toString(flag));
    }

    Element getModConfig(String s2) {
        return this.getElement(this.getMod(s2), TAG_CONFIG1);
    }

    Element getModConfig(String s2, String s1) {
        return this.getElement(this.getModConfig(s2), s1);
    }

    String getModConfigValue(String s2, String s1) {
        return this.getText(this.getModConfig(s2, s1));
    }

    void setModConfigValue(String s2, String s1, String s22) {
        Element element = this.getModConfig(s2, s1);
        if (element != null) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            element.appendChild(this.xml.createTextNode(s22));
        }
    }

    private void buildNewProperties() {
        if (this.xml != null) {
            this.getRoot();
            this.getConfig();
            this.getMods();
            this.setText(this.getMod("HD Textures"), TAG_ENABLED, "true");
            this.setText(this.getMod("HD Font"), TAG_ENABLED, "true");
            this.setText(this.getMod("Better Grass"), TAG_ENABLED, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveProperties() {
        boolean flag = false;
        if (this.xml != null && this.xmlFile != null) {
            FileOutputStream fileoutputstream = null;
            try {
                fileoutputstream = new FileOutputStream(this.xmlFile);
                TransformerFactory transformerfactory = TransformerFactory.newInstance();
                Transformer transformer = transformerfactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                DOMSource domsource = new DOMSource(this.xml);
                transformer.transform(domsource, new StreamResult(new OutputStreamWriter((OutputStream)fileoutputstream, "UTF-8")));
                flag = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (fileoutputstream != null) {
                    try {
                        fileoutputstream.close();
                    }
                    catch (IOException ioexception) {
                        ioexception.printStackTrace();
                    }
                }
            }
        }
        return flag;
    }
}

