/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.evolutions.beta.voip;

import com.johnymuffin.evolutions.beta.BetaEVO;
import com.johnymuffin.evolutions.beta.voip.VOIPConnection;
import com.johnymuffin.evolutions.beta.voip.VOIPHandler;
import com.johnymuffin.evolutions.beta.voip.VOIPPacket;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import javax.sound.sampled.SourceDataLine;

public class VOIPSpeakerThread
extends Thread {
    private volatile boolean running;
    private VOIPHandler voipHandler;
    private VOIPConnection voipConnection;
    private SourceDataLine sourceDataLine;

    public VOIPSpeakerThread(VOIPHandler voipHandler) {
        this.voipHandler = voipHandler;
        this.voipConnection = voipHandler.getVoipvoipConnection();
    }

    @Override
    public void run() {
        this.running = true;
        HashMap playerVoiceOutputs = new HashMap();
        while (this.running) {
            VOIPPacket packet;
            try {
                packet = this.voipConnection.receive().get();
            }
            catch (SocketTimeoutException ex2) {
                continue;
            }
            catch (IOException | InterruptedException | ExecutionException ex3) {
                if (ex3.getMessage().equals("java.net.SocketTimeoutException: Receive timed out")) continue;
                ex3.printStackTrace();
                continue;
            }
            if (!packet.isValid() || packet.getType() != VOIPPacket.VOIPPacketType.VOIP) continue;
            ArrayList<Byte> speakerUid = new ArrayList<Byte>(packet.getSpeakerUid().length);
            for (int i2 = 0; i2 < packet.getSpeakerUid().length; ++i2) {
                speakerUid.add(packet.getSpeakerUid()[i2]);
            }
            if (!playerVoiceOutputs.containsKey(speakerUid)) {
                SourceDataLine playerVoiceOutput = BetaEVO.getInstance().getPlayerVoiceOutput();
                playerVoiceOutputs.put(Collections.unmodifiableList(speakerUid), playerVoiceOutput);
            }
            SourceDataLine playerVoiceOutput = (SourceDataLine)playerVoiceOutputs.get(speakerUid);
            playerVoiceOutput.write(packet.getAudio(), 0, 2000);
        }
        System.out.println("VOIP Speaker thread shutting down");
    }

    public void shutdown() {
        this.running = false;
    }
}

