/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.evolutions.beta.voip;

import com.johnymuffin.evolutions.beta.BetaEVO;
import com.johnymuffin.evolutions.beta.voip.VOIPConnection;
import com.johnymuffin.evolutions.beta.voip.VOIPHandler;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.TargetDataLine;

public class VOIPRecordingThread
extends Thread {
    private volatile boolean running;
    private VOIPHandler voipHandler;
    private VOIPConnection voipConnection;
    public AtomicBoolean pushToTalk = new AtomicBoolean(false);

    public VOIPRecordingThread(VOIPHandler voipHandler) {
        this.voipHandler = voipHandler;
        this.voipConnection = voipHandler.getVoipvoipConnection();
    }

    @Override
    public void run() {
        this.running = true;
        TargetDataLine mic = BetaEVO.getInstance().getMic();
        byte[] audio = new byte[2000];
        while (this.running) {
            if (!this.pushToTalk.get()) continue;
            mic.read(audio, 0, audio.length);
            try {
                this.voipConnection.voice(audio);
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
        System.out.println("VOIP Microphone thread shutting down");
    }

    public void shutdown() {
        this.running = false;
    }

    public AtomicBoolean getPushToTalk() {
        return this.pushToTalk;
    }
}

