/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.evolutions.beta.voip;

import com.johnymuffin.evolutions.beta.BetaEVO;
import com.johnymuffin.evolutions.beta.voip.VOIPConnection;
import com.johnymuffin.evolutions.beta.voip.VOIPRecordingThread;
import com.johnymuffin.evolutions.beta.voip.VOIPSpeakerThread;
import java.net.InetSocketAddress;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class VOIPHandler
extends Thread {
    private VOIPRecordingThread voipRecordingThread;
    private VOIPSpeakerThread voipSpeakerThread;
    private VOIPConnection voipvoipConnection;
    private String ip;
    private int port;
    private String code;

    public VOIPHandler(String ip2, int port, String code) {
        this.ip = ip2;
        this.port = port;
        this.code = code;
    }

    @Override
    public void run() {
        System.out.println("VOIP: Starting voipConnection.");
        try {
            System.out.println("Connecting to " + this.ip + ":" + this.port + " with code " + this.code);
            this.voipvoipConnection = new VOIPConnection(new InetSocketAddress(this.ip, this.port));
            if (!this.voipvoipConnection.signIn(this.code).get().booleanValue()) {
                System.out.println("The remote server failed to accept the identifier code.");
                return;
            }
            this.voipRecordingThread = new VOIPRecordingThread(this);
            this.voipSpeakerThread = new VOIPSpeakerThread(this);
            this.voipRecordingThread.start();
            this.voipSpeakerThread.start();
            BetaEVO.getInstance().setVoipEnabled(true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void shutdown() {
        BetaEVO.getInstance().setVoipEnabled(false);
        this.voipRecordingThread.shutdown();
        this.voipSpeakerThread.shutdown();
    }

    public static TargetDataLine getMic() throws LineUnavailableException {
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, true);
        TargetDataLine line = AudioSystem.getTargetDataLine(format);
        line.open();
        line.start();
        return line;
    }

    public static SourceDataLine getAudioOutput() throws LineUnavailableException {
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, true);
        SourceDataLine line = AudioSystem.getSourceDataLine(format);
        line.open();
        line.start();
        return line;
    }

    public VOIPRecordingThread getVoipRecordingThread() {
        return this.voipRecordingThread;
    }

    public VOIPSpeakerThread getVoipSpeakerThread() {
        return this.voipSpeakerThread;
    }

    public VOIPConnection getVoipvoipConnection() {
        return this.voipvoipConnection;
    }
}

