/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.evolutions.beta;

import com.johnymuffin.evolutions.beta.BetaEVO;
import com.johnymuffin.evolutions.beta.nametag.TagColor;
import com.johnymuffin.evolutions.beta.packets.Packet220Cosmetic;
import com.johnymuffin.evolutions.beta.simplejson.JSONArray;
import com.johnymuffin.evolutions.beta.simplejson.JSONObject;
import com.johnymuffin.evolutions.beta.simplejson.parser.JSONParser;
import com.johnymuffin.evolutions.beta.simplejson.parser.ParseException;
import com.johnymuffin.evolutions.beta.voip.VOIPHandler;

public class UpdateReceiver {
    public static void processUpdates(String text) {
        try {
            JSONParser jsonParser = new JSONParser();
            JSONArray updates = (JSONArray)jsonParser.parse(text);
            UpdateReceiver.processUpdates(updates);
        }
        catch (ParseException e2) {
            System.out.println("Received an invalid update array, skipping!");
        }
    }

    private static void processUpdates(JSONArray jsonArray) {
        for (Object object : jsonArray) {
            JSONObject update = (JSONObject)object;
            UpdateReceiver.processUpdate(update);
        }
    }

    private static void processUpdate(JSONObject jsonObject) {
        if (!jsonObject.containsKey("protocol")) {
            UpdateReceiver.updateError(jsonObject, "Invalid update, doesn't contain protocol id.");
            return;
        }
        if (!jsonObject.containsKey("updateType")) {
            UpdateReceiver.updateError(jsonObject, "Invalid update, doesn't contain update types");
            return;
        }
        if (String.valueOf(jsonObject.get("updateType")).equals("handshake")) {
            if (jsonObject.containsKey("protocol")) {
                System.out.println("Establishing two way communication with the server.");
                JSONObject packetResponse = new JSONObject();
                packetResponse.put("protocol", 2);
                packetResponse.put("updateType", "handshake");
                Packet220Cosmetic packet220Cosmetic = new Packet220Cosmetic("[" + packetResponse.toJSONString() + "]");
                UpdateReceiver.sendPacket(packet220Cosmetic);
                return;
            }
            UpdateReceiver.updateError(jsonObject, "Not enough fields are provided.");
            return;
        }
        if (String.valueOf(jsonObject.get("updateType")).equals("VOIPRequest")) {
            if (jsonObject.containsKey("protocol")) {
                if (BetaEVO.getInstance().getVoipHandler() != null) {
                    BetaEVO.getInstance().getVoipHandler().shutdown();
                    BetaEVO.getInstance().getVoipHandler().interrupt();
                }
                VOIPHandler voipHandler = new VOIPHandler(String.valueOf(jsonObject.get("ip")), Integer.valueOf(String.valueOf(jsonObject.get("port"))), String.valueOf(jsonObject.get("code")));
                voipHandler.start();
                BetaEVO.getInstance().setVoipHandler(voipHandler);
                return;
            }
            UpdateReceiver.updateError(jsonObject, "Not enough fields are provided.");
            return;
        }
        if (String.valueOf(jsonObject.get("updateType")).equals("basicNameTagUpdate")) {
            if (jsonObject.containsKey("player") && jsonObject.containsKey("color")) {
                String playerName = String.valueOf(jsonObject.get("player"));
                String rawColor = String.valueOf(jsonObject.get("color"));
                TagColor tagColor = TagColor.valueOf(rawColor);
                if (tagColor != null) {
                    BetaEVO.getInstance().basicNameTagUpdate(tagColor, playerName);
                    return;
                }
                UpdateReceiver.updateError(jsonObject, "Unknown color type.");
                return;
            }
            UpdateReceiver.updateError(jsonObject, "Not enough fields are provided.");
            return;
        }
        if (String.valueOf(jsonObject.get("updateType")).equals("complexNameTagUpdate")) {
            if (jsonObject.containsKey("player") && jsonObject.containsKey("colorCode") && jsonObject.containsKey("backLight")) {
                String playerName = String.valueOf(jsonObject.get("player"));
                int colorCode = Integer.valueOf(String.valueOf(jsonObject.get("colorCode")));
                boolean backLight = Boolean.getBoolean(String.valueOf(jsonObject.get("backLight")));
                BetaEVO.getInstance().complexNameTagUpdate(colorCode, backLight, playerName);
                return;
            }
            UpdateReceiver.updateError(jsonObject, "Not enough fields are provided.");
            return;
        }
        if (String.valueOf(jsonObject.get("updateType")).equals("mouseEars")) {
            if (jsonObject.containsKey("player") && jsonObject.containsKey("enabled")) {
                String playerName = String.valueOf(jsonObject.get("player"));
                boolean enabled = Boolean.valueOf(String.valueOf(jsonObject.get("enabled")));
                BetaEVO.getInstance().setMouseEars(enabled, playerName);
                return;
            }
            UpdateReceiver.updateError(jsonObject, "Not enough fields are provided.");
            return;
        }
        if (String.valueOf(jsonObject.get("updateType")).equals("fly")) {
            if (jsonObject.containsKey("enabled")) {
                boolean enabled = Boolean.valueOf(String.valueOf(jsonObject.get("enabled")));
                BetaEVO.getInstance().setAllowFlying(enabled);
                return;
            }
            UpdateReceiver.updateError(jsonObject, "Not enough fields are provided.");
            return;
        }
        UpdateReceiver.updateError(jsonObject, "Unknown Update Type");
    }

    private static void updateError(JSONObject jsonObject, String errorMessage) {
        System.out.println("An error occurred processing an update: " + errorMessage + ". " + jsonObject.toJSONString());
    }

    public static void sendPacket(ki packet) {
        if (BetaEVO.getInstance().getMinecraft().f.B) {
            BetaEVO.getInstance().getMinecraft().s().b(packet);
        }
    }
}

