/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.evolutions.beta;

import com.johnymuffin.evolutions.beta.DiscordThread;
import com.johnymuffin.evolutions.beta.JsonReader;
import com.johnymuffin.evolutions.beta.nametag.TagColor;
import com.johnymuffin.evolutions.beta.nametag.UsableTagColor;
import com.johnymuffin.evolutions.beta.simplejson.JSONObject;
import com.johnymuffin.evolutions.beta.voip.VOIPHandler;
import de.jcm.discordgamesdk.activity.Activity;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.client.Minecraft;

public class BetaEVO {
    private static BetaEVO betaEVO;
    private UsableTagColor defaultUsernameColor = new UsableTagColor(TagColor.NORMAL);
    private HashMap<String, UsableTagColor> nameTagColorCache = new HashMap();
    private ArrayList<String> mouseEars = new ArrayList<String>(Arrays.asList(new String[0]));
    private String skinURL = "http://s3.amazonaws.com/MinecraftSkins/<username>.png";
    private String cloakURL = "http://s3.amazonaws.com/MinecraftCloaks/<username>.png";
    private String resourceURL = "http://s3.amazonaws.com/MinecraftResources/";
    private String authURL = "http://www.minecraft.net/game/joinserver.jsp?user=<username>&sessionId=<sessionid>&serverId=<serverId>";
    private final String version = "1.4.5";
    private String newestVersion = "1.4.5";
    private int authenticationCount = 0;
    private Object authLock = new Object();
    private boolean allowFlying = false;
    private long discordStartTime;
    public DiscordThread discordThread;
    private Minecraft minecraft;
    private VOIPHandler voipHandler;
    private Object micSpeakerLock = new Object();
    private TargetDataLine mic;
    private SourceDataLine playerVoiceOutput;
    private boolean voipEnabled = false;

    public void setVoipEnabled(boolean voipEnabled) {
        this.voipEnabled = voipEnabled;
    }

    private BetaEVO() {
        try {
            String[] certs = new String[]{"isrgrootx1.der", "lets-encrypt-r3.der"};
            BetaEVO.setTrustStore(certs);
        }
        catch (Exception e2) {
            new RuntimeException(e2);
        }
        try {
            JSONObject jsonObject = JsonReader.readJsonFromUrl("https://api.johnymuffin.com/clientinfo.json");
            if (jsonObject.containsKey("skinURL")) {
                this.skinURL = String.valueOf(jsonObject.get("skinURL"));
            }
            if (jsonObject.containsKey("cloakURL")) {
                this.cloakURL = String.valueOf(jsonObject.get("cloakURL"));
            }
            if (jsonObject.containsKey("resourcesURL")) {
                this.resourceURL = String.valueOf(jsonObject.get("resourcesURL"));
            }
            if (jsonObject.containsKey("authURL")) {
                this.authURL = String.valueOf(jsonObject.get("authURL"));
            }
            if (jsonObject.containsKey("newestClient")) {
                this.newestVersion = String.valueOf(jsonObject.get("newestClient"));
            }
            System.out.println("Loaded BetaEvolutions Manifest.");
        }
        catch (Exception e3) {
            System.out.println("An error occurred fetching the manifest: ");
            e3.printStackTrace();
        }
        this.discordStartTime = System.currentTimeMillis();
        this.discordThread = new DiscordThread(this);
        try {
            this.discordThread.start();
        }
        catch (Exception e3) {
            // empty catch block
        }
        try {
            this.setMic(VOIPHandler.getMic());
            this.setPlayerVoiceOutput(VOIPHandler.getAudioOutput());
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
    }

    public static void setTrustStore(String[] trustStoreString) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        keystore.load(Files.newInputStream(ksPath, new OpenOption[0]), "changeit".toCharArray());
        for (String trustStore : trustStoreString) {
            InputStream keystoreStream = BetaEVO.class.getResourceAsStream(trustStore);
            CertificateFactory cf2 = CertificateFactory.getInstance("X.509");
            Certificate crt = cf2.generateCertificate(keystoreStream);
            System.out.println("Added Cert for " + ((X509Certificate)crt).getSubjectDN());
            keystore.setCertificateEntry(trustStore.replace(".der", ""), crt);
        }
        trustManagerFactory.init(keystore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sc2 = SSLContext.getInstance("SSL");
        sc2.init(null, trustManagers, null);
        SSLContext.setDefault(sc2);
    }

    public static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("Encode Error.");
        }
    }

    public void basicNameTagUpdate(TagColor color, String playerName) {
        this.nameTagColorCache.put(playerName, new UsableTagColor(color));
    }

    public void complexNameTagUpdate(int color, boolean backLight, String playerName) {
        this.nameTagColorCache.put(playerName, new UsableTagColor(color, backLight));
    }

    public UsableTagColor getUsernameTagColor(String playerName) {
        if (this.nameTagColorCache.containsKey(playerName)) {
            return this.nameTagColorCache.get(playerName);
        }
        return this.defaultUsernameColor;
    }

    public void setMouseEars(boolean enabled, String playerName) {
        if (this.mouseEars.contains(playerName)) {
            if (!enabled) {
                this.mouseEars.remove(playerName);
            }
        } else if (enabled) {
            this.mouseEars.add(playerName);
        }
    }

    public boolean hasMouseEars(String playerName) {
        return this.mouseEars.contains(playerName);
    }

    public static BetaEVO getInstance() {
        if (betaEVO == null) {
            betaEVO = new BetaEVO();
        }
        return betaEVO;
    }

    public String getSkinURL() {
        return this.skinURL;
    }

    public String getCloakURL() {
        return this.cloakURL;
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public String getAuthURL() {
        return this.authURL;
    }

    public String getVersion() {
        return "1.4.5";
    }

    public String getNewestVersion() {
        return this.newestVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAuthenticationCount() {
        Object object = this.authLock;
        synchronized (object) {
            return this.authenticationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationEnabled(int authenticationCount) {
        Object object = this.authLock;
        synchronized (object) {
            this.authenticationCount = authenticationCount;
        }
    }

    public boolean isFlyingAllowed() {
        return this.allowFlying;
    }

    public void setAllowFlying(boolean flying) {
        this.allowFlying = flying;
    }

    public void wipeSessionData() {
        this.allowFlying = false;
        this.nameTagColorCache = new HashMap();
        this.mouseEars = new ArrayList<String>(Arrays.asList(new String[0]));
    }

    public void updateRichPresence(Activity activity) {
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public void setMinecraft(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public VOIPHandler getVoipHandler() {
        return this.voipHandler;
    }

    public void setVoipHandler(VOIPHandler voipHandler) {
        this.voipHandler = voipHandler;
    }

    public boolean isVoipEnabled() {
        return this.voipEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetDataLine getMic() {
        Object object = this.micSpeakerLock;
        synchronized (object) {
            return this.mic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMic(TargetDataLine mic) {
        Object object = this.micSpeakerLock;
        synchronized (object) {
            this.mic = mic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceDataLine getPlayerVoiceOutput() {
        Object object = this.micSpeakerLock;
        synchronized (object) {
            return this.playerVoiceOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerVoiceOutput(SourceDataLine playerVoiceOutput) {
        Object object = this.micSpeakerLock;
        synchronized (object) {
            this.playerVoiceOutput = playerVoiceOutput;
        }
    }
}

