/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImprovedChat {
    static Minecraft m;
    static Server Global;
    static Server Current;
    private static Hashtable servers;
    static Hashtable constantVar;
    public static ArrayList pastCommands;
    private static PatternList[] d;
    private static File settings;
    private static File constantsFile;
    private static File colors;
    private static File minecraftDir;
    private static File modDir;
    private static final int input = 0;
    private static final int output = 1;
    private static final int display = 2;
    private static final Pattern space;
    private static Hashtable colorHex;
    private static boolean chatDisabled;
    public static int bgOpacity;
    public static int bgColor;
    public static int historyOpacity;
    public static int historyColor;
    private static Document doc;
    private static Element topElement;
    private static Pattern colorCrashFix;
    private static Pattern colorTags;
    private static Pattern updateColor;
    private static Pattern buxvillFix;
    private static Pattern varP;
    private static Pattern varPinB;
    private static Pattern fixInvalidCharacter;
    private static Hashtable commands;
    private static Pattern scriptVar;
    private static Clipboard clipboard;

    private static void createColorFile() {
        try {
            PrintWriter printwriter = new PrintWriter(colors);
            printwriter.println("black:0");
            printwriter.println("darkgreen:0x7F00");
            printwriter.println("darkblue:0x7F");
            printwriter.println("darkred:0x7F0000");
            printwriter.println("darkteal:0x7F7F");
            printwriter.println("purple:0x7F007F");
            printwriter.println("gold:0x7F7F00");
            printwriter.println("gray:0x7F7F7F");
            printwriter.println("blue:0xFF");
            printwriter.println("green:0xFF00");
            printwriter.println("teal:0xFFFF");
            printwriter.println("red:0xFF0000");
            printwriter.println("pink:0xFF00FF");
            printwriter.println("yellow:0xFFFF00");
            printwriter.println("white:0xFFFFFF");
            printwriter.close();
        }
        catch (FileNotFoundException filenotfoundexception) {
            filenotfoundexception.printStackTrace();
        }
    }

    private static void versionConvert() {
        File file = settings.getParentFile();
        if (!file.exists() && !settings.getParentFile().mkdirs()) {
            return;
        }
        File file1 = new File(minecraftDir, "ImprovedChat.xml");
        File file2 = new File(minecraftDir, "vars.txt");
        if (file1.exists()) {
            file1.renameTo(settings);
        }
        if (file2.exists()) {
            file2.renameTo(constantsFile);
        }
    }

    public static void init(Minecraft minecraft) {
        m = minecraft;
        new ImprovedChat();
    }

    private static Element newElem(Element element, String s2) {
        Element element1 = doc.createElement(s2);
        element.appendChild(element1);
        return element1;
    }

    private static void addTextNode(Element element, String s2) {
        element.appendChild(doc.createTextNode(s2));
    }

    private static void save() {
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserconfigurationexception) {
            parserconfigurationexception.printStackTrace();
            return;
        }
        topElement = doc.createElement("Properties");
        doc.appendChild(topElement);
        topElement = ImprovedChat.newElem(topElement, "Input");
        for (PatternList.Entry entry : ImprovedChat.d[0].list) {
            Element element = ImprovedChat.newElem(topElement, "entry");
            element.setAttribute("regex", entry.pattern.toString());
            ImprovedChat.addTextNode(element, entry.replacement);
        }
        topElement = (Element)topElement.getParentNode();
        topElement = ImprovedChat.newElem(topElement, "Output");
        for (PatternList.Entry entry1 : ImprovedChat.d[1].list) {
            Element element1 = ImprovedChat.newElem(topElement, "entry");
            element1.setAttribute("regex", entry1.pattern.toString());
            ImprovedChat.addTextNode(element1, entry1.replacement);
        }
        topElement = (Element)topElement.getParentNode();
        topElement = ImprovedChat.newElem(topElement, "Display");
        for (PatternList.Entry entry2 : ImprovedChat.d[2].list) {
            Element element2 = ImprovedChat.newElem(topElement, "entry");
            element2.setAttribute("regex", entry2.pattern.toString());
            ImprovedChat.addTextNode(element2, entry2.replacement);
        }
        topElement = (Element)topElement.getParentNode();
        Element element3 = ImprovedChat.newElem(topElement, "ChatBox");
        element3.setAttribute("Color", "" + bgColor);
        element3.setAttribute("Opacity", "" + bgOpacity);
        element3 = ImprovedChat.newElem(topElement, "ChatHistory");
        element3.setAttribute("Color", "" + historyColor);
        element3.setAttribute("Opacity", "" + historyOpacity);
        topElement = ImprovedChat.newElem(topElement, "Servers");
        Enumeration enumeration = servers.keys();
        ImprovedChat.saveServer(Global);
        while (enumeration.hasMoreElements()) {
            ImprovedChat.saveServer((Server)servers.get(enumeration.nextElement()));
        }
        topElement = (Element)topElement.getParentNode();
        try {
            TransformerFactory transformerfactory = TransformerFactory.newInstance();
            Transformer transformer = transformerfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            transformer.setOutputProperty("standalone", "yes");
            DOMSource domsource = new DOMSource(doc);
            StreamResult streamresult = new StreamResult(settings);
            transformer.transform(domsource, streamresult);
        }
        catch (TransformerException transformerexception) {
            transformerexception.printStackTrace();
        }
    }

    private static void saveServer(Server server) {
        topElement = ImprovedChat.newElem(topElement, "Server");
        topElement.setAttribute("name", server.name);
        topElement.setAttribute("address", server.address);
        for (int i2 = 0; i2 < 4; ++i2) {
            topElement = ImprovedChat.newElem(topElement, "Bindings");
            topElement.setAttribute("type", "" + i2);
            Enumeration enumeration = server.bindings[i2].keys();
            while (enumeration.hasMoreElements()) {
                Integer integer = (Integer)enumeration.nextElement();
                Element element = ImprovedChat.newElem(topElement, "entry");
                element.setAttribute("key", integer.toString());
                ImprovedChat.addTextNode(element, (String)server.bindings[i2].get(integer));
            }
            topElement = (Element)topElement.getParentNode();
        }
        topElement = ImprovedChat.newElem(topElement, "Variables");
        Enumeration enumeration1 = server.vars.keys();
        while (enumeration1.hasMoreElements()) {
            String s2 = (String)enumeration1.nextElement();
            Element element1 = ImprovedChat.newElem(topElement, "entry");
            element1.setAttribute("var", s2);
            ImprovedChat.addTextNode(element1, server.vars.getPattern(s2));
        }
        topElement = (Element)topElement.getParentNode();
        topElement = ImprovedChat.newElem(topElement, "Tabs");
        for (int j2 = 0; j2 < server.tabs.size(); ++j2) {
            TabIMC tabIMC = (TabIMC)server.tabs.get(j2);
            if (tabIMC == null) continue;
            topElement = ImprovedChat.newElem(topElement, "Tab");
            topElement.setAttribute("prefix", tabIMC.prefix);
            ImprovedChat.addTextNode(ImprovedChat.newElem(topElement, "name"), tabIMC.name);
            if (tabIMC.blink) {
                ImprovedChat.newElem(topElement, "blink");
            }
            for (Pattern pattern : tabIMC.track) {
                ImprovedChat.addTextNode(ImprovedChat.newElem(topElement, "track"), pattern.pattern());
            }
            for (Pattern pattern1 : tabIMC.ignore) {
                ImprovedChat.addTextNode(ImprovedChat.newElem(topElement, "ignore"), pattern1.pattern());
            }
            topElement = (Element)topElement.getParentNode();
        }
        topElement = (Element)topElement.getParentNode();
        if (server.translations != null) {
            Element element2 = ImprovedChat.newElem(topElement, "Translation");
            element2.setAttribute("from", server.translations[0]);
            element2.setAttribute("to", server.translations[1]);
        }
        topElement = (Element)topElement.getParentNode();
    }

    private static void load() {
        Object obj = null;
        if (!settings.exists()) {
            return;
        }
        try {
            Element element4;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(settings);
            Element element = document.getDocumentElement();
            element.normalize();
            Node node = element.getElementsByTagName("Input").item(0);
            if (node != null && node.getNodeType() == 1) {
                d[0].clear();
                NodeList nodelist1 = ((Element)node).getElementsByTagName("entry");
                for (int i2 = 0; i2 < nodelist1.getLength(); ++i2) {
                    Element element1 = (Element)nodelist1.item(i2);
                    d[0].add(element1.getAttribute("regex"), element1.getTextContent());
                }
            }
            if ((node = element.getElementsByTagName("Output").item(0)) != null && node.getNodeType() == 1) {
                d[1].clear();
                NodeList nodelist2 = ((Element)node).getElementsByTagName("entry");
                for (int j2 = 0; j2 < nodelist2.getLength(); ++j2) {
                    Element element2 = (Element)nodelist2.item(j2);
                    d[1].add(element2.getAttribute("regex"), element2.getTextContent());
                }
            }
            if ((node = element.getElementsByTagName("Display").item(0)) != null && node.getNodeType() == 1) {
                d[2].clear();
                NodeList nodelist3 = ((Element)node).getElementsByTagName("entry");
                for (int k2 = 0; k2 < nodelist3.getLength(); ++k2) {
                    Element element3 = (Element)nodelist3.item(k2);
                    d[2].add(element3.getAttribute("regex"), element3.getTextContent());
                }
            }
            if ((element4 = (Element)element.getElementsByTagName("ChatBox").item(0)) != null) {
                String s1 = element4.getAttribute("Color");
                if (s1 != null) {
                    try {
                        bgColor = Integer.parseInt(s1);
                    }
                    catch (NumberFormatException element3) {
                        // empty catch block
                    }
                }
                if ((s1 = element4.getAttribute("Opacity")) != null) {
                    try {
                        bgOpacity = Integer.parseInt(s1);
                    }
                    catch (NumberFormatException element3) {
                        // empty catch block
                    }
                }
            }
            if ((element4 = (Element)element.getElementsByTagName("ChatHistory").item(0)) != null) {
                String s2 = element4.getAttribute("Color");
                if (s2 != null) {
                    try {
                        historyColor = Integer.parseInt(s2);
                    }
                    catch (NumberFormatException element3) {
                        // empty catch block
                    }
                }
                if ((s2 = element4.getAttribute("Opacity")) != null) {
                    try {
                        historyOpacity = Integer.parseInt(s2);
                    }
                    catch (NumberFormatException element3) {
                        // empty catch block
                    }
                }
            }
            if ((element4 = (Element)element.getElementsByTagName("Servers").item(0)) != null) {
                NodeList nodelist4 = element4.getElementsByTagName("Server");
                for (int l2 = 0; l2 < nodelist4.getLength(); ++l2) {
                    Element element7 = (Element)nodelist4.item(l2);
                    Server server = new Server(element7.getAttribute("name"), element7.getAttribute("address"));
                    NodeList nodelist = element7.getElementsByTagName("Bindings");
                    for (int i1 = 0; i1 < nodelist.getLength(); ++i1) {
                        Element element8 = (Element)nodelist.item(i1);
                        String s3 = element8.getAttribute("type");
                        int l1 = 0;
                        if (s3 != null && !s3.equals("")) {
                            l1 = Integer.parseInt(s3);
                        }
                        server.bindings[l1].clear();
                        NodeList nodelist7 = element8.getElementsByTagName("entry");
                        for (int i2 = 0; i2 < nodelist7.getLength(); ++i2) {
                            Element element5 = (Element)nodelist7.item(i2);
                            server.bindings[l1].put(new Integer(Integer.parseInt(element5.getAttribute("key"))), element5.getTextContent());
                        }
                    }
                    Node node1 = element7.getElementsByTagName("Variables").item(0);
                    if (node1 != null && node1.getNodeType() == 1) {
                        NodeList nodelist5 = ((Element)node1).getElementsByTagName("entry");
                        server.vars.clear();
                        for (int j1 = 0; j1 < nodelist5.getLength(); ++j1) {
                            Element element6 = (Element)nodelist5.item(j1);
                            server.vars.add(element6.getAttribute("var"), element6.getTextContent());
                        }
                    }
                    if ((node1 = element7.getElementsByTagName("Tabs").item(0)) != null && node1.getNodeType() == 1) {
                        NodeList nodelist6 = ((Element)node1).getElementsByTagName("Tab");
                        for (int k1 = 0; k1 < nodelist6.getLength(); ++k1) {
                            Element element9 = (Element)nodelist6.item(k1);
                            String s4 = element9.getElementsByTagName("name").item(0).getTextContent();
                            TabIMC tabIMC = new TabIMC(s4);
                            server.tabs.add(tabIMC);
                            tabIMC.prefix = element9.getAttribute("prefix");
                            tabIMC.blink = element9.getElementsByTagName("blink").item(0) != null;
                            NodeList nodelist8 = element9.getElementsByTagName("track");
                            for (int j2 = 0; j2 < nodelist8.getLength(); ++j2) {
                                tabIMC.track(nodelist8.item(j2).getTextContent());
                            }
                            nodelist8 = element9.getElementsByTagName("ignore");
                            for (int k2 = 0; k2 < nodelist8.getLength(); ++k2) {
                                tabIMC.ignore(nodelist8.item(k2).getTextContent());
                            }
                        }
                    }
                    if (server.name.equals("Global") && server.address.equals("")) {
                        Global = server;
                        continue;
                    }
                    servers.put(server.name, server);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!constantsFile.exists()) {
            return;
        }
        try {
            String s2;
            constantVar.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(constantsFile));
            while ((s2 = bufferedreader.readLine()) != null) {
                String[] as2;
                if ((s2 = s2.split("#", 2)[0]).equals("") || (as2 = s2.split(" ", 2)).length != 2) continue;
                constantVar.put(as2[0], as2[1]);
            }
            bufferedreader.close();
        }
        catch (FileNotFoundException filenotfoundexception) {
            filenotfoundexception.printStackTrace();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public static int getColorHex(String s2) {
        Integer integer = (Integer)colorHex.get(s2);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    public static void listKB() {
        ImprovedChat.unProccessedInput("Global key bindings:");
        String[] as2 = new String[]{"", "ctrl-", "shift-", "ctrl-shift-"};
        for (int i2 = 0; i2 < 4; ++i2) {
            Enumeration enumeration = ImprovedChat.Global.bindings[i2].keys();
            while (enumeration.hasMoreElements()) {
                Integer integer = (Integer)enumeration.nextElement();
                ImprovedChat.unProccessedInput(String.valueOf(as2[i2]) + Keyboard.getKeyName((int)integer) + ": " + (String)ImprovedChat.Global.bindings[i2].get(integer));
            }
        }
        ImprovedChat.unProccessedInput("Server specific key bindings");
        for (int j2 = 0; j2 < 4; ++j2) {
            Enumeration enumeration1 = ImprovedChat.Current.bindings[j2].keys();
            while (enumeration1.hasMoreElements()) {
                Integer integer1 = (Integer)enumeration1.nextElement();
                ImprovedChat.unProccessedInput(String.valueOf(as2[j2]) + Keyboard.getKeyName((int)integer1) + ": " + (String)ImprovedChat.Current.bindings[j2].get(integer1));
            }
        }
    }

    public static void addKB(String s2, String s1) {
        int j2;
        int i2 = 0;
        if ((s2 = s2.toUpperCase()).startsWith("CTRL-")) {
            ++i2;
            s2 = s2.substring(5);
        }
        if (s2.startsWith("SHIFT-")) {
            i2 += 2;
            s2 = s2.substring(6);
        }
        if ((j2 = Keyboard.getKeyIndex((String)s2)) == 0) {
            ImprovedChat.stderr("There is no key with name " + s2);
            return;
        }
        ImprovedChat.Current.bindings[i2].put(new Integer(j2), s1);
    }

    public static boolean removeKB(String s2) {
        int j2;
        String s1;
        int i2 = 0;
        if ((s2 = s2.toUpperCase()).startsWith("CTRL-")) {
            ++i2;
            s2 = s2.substring(5);
        }
        if (s2.startsWith("SHIFT-")) {
            i2 += 2;
            s2 = s2.substring(6);
        }
        return (s1 = (String)ImprovedChat.Current.bindings[i2].remove(new Integer(j2 = Keyboard.getKeyIndex((String)s2)))) != null;
    }

    public static void listVars() {
        ImprovedChat.unProccessedInput("Global variables");
        Enumeration enumeration = ImprovedChat.Global.vars.keys();
        while (enumeration.hasMoreElements()) {
            String s2 = (String)enumeration.nextElement();
            ImprovedChat.unProccessedInput(String.valueOf(s2) + ":" + ImprovedChat.Global.vars.getPattern(s2));
        }
        ImprovedChat.unProccessedInput("Server specific variables");
        Enumeration enumeration1 = ImprovedChat.Current.vars.keys();
        while (enumeration1.hasMoreElements()) {
            String s1 = (String)enumeration1.nextElement();
            ImprovedChat.unProccessedInput(String.valueOf(s1) + ":" + ImprovedChat.Current.vars.getPattern(s1));
        }
    }

    public static String getVar(String s2) {
        if (s2.equals("time")) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat simpledateformat = new SimpleDateFormat("HH:mm:ss");
            return simpledateformat.format(calendar.getTime());
        }
        Variables.Variable variable = ImprovedChat.Current.vars.get(s2);
        if (variable == null) {
            variable = ImprovedChat.Global.vars.get(s2);
        }
        String s1 = variable == null ? (String)constantVar.get(s2) : variable.value;
        return s1;
    }

    public static void removeVar(String s2) {
        ImprovedChat.Current.vars.remove(s2);
    }

    public static void varProcess(String s2) {
        ImprovedChat.Global.vars.process(s2);
        ImprovedChat.Current.vars.process(s2);
    }

    public static void addRule(String s2, String s1, String s22) {
        if (s2.equalsIgnoreCase("input")) {
            d[0].add(s1, s22);
        } else if (s2.equalsIgnoreCase("output")) {
            d[1].add(s1, s22);
        } else if (s2.equalsIgnoreCase("display")) {
            d[2].add(s1, s22);
        }
    }

    public static void removeRule(String s2, int i2) {
        ArrayList arraylist = null;
        if (s2.equalsIgnoreCase("input")) {
            arraylist = ImprovedChat.d[0].list;
        } else if (s2.equalsIgnoreCase("output")) {
            arraylist = ImprovedChat.d[1].list;
        } else if (s2.equalsIgnoreCase("display")) {
            arraylist = ImprovedChat.d[2].list;
        }
        if (arraylist == null) {
            ImprovedChat.console("Usage: ~delete bind <KeyName>");
            ImprovedChat.console("Usage: ~delete var <VarName>");
            ImprovedChat.console("Usage: ~delete (input|output|display) id");
            return;
        }
        if (i2 >= 0 && i2 < arraylist.size()) {
            arraylist.remove(i2);
            ImprovedChat.console("Deleted rule successful");
        } else {
            ImprovedChat.console("Delete: index out of bounds.");
        }
    }

    public static boolean moveRule(String s2, int i2, int j2) {
        if (s2.equalsIgnoreCase("input")) {
            ImprovedChat.console(d[0].move(i2, j2));
        } else if (s2.equalsIgnoreCase("output")) {
            ImprovedChat.console(d[1].move(i2, j2));
        } else if (s2.equalsIgnoreCase("display")) {
            ImprovedChat.console(d[2].move(i2, j2));
        } else {
            return false;
        }
        return true;
    }

    public static boolean list(String s2) {
        if (s2.equals("input")) {
            d[0].list();
        } else if (s2.equals("output")) {
            d[1].list();
        } else if (s2.equals("display")) {
            d[2].list();
        } else {
            return false;
        }
        return true;
    }

    private static String firstChar(String s2) {
        int i2;
        String s1 = "";
        for (i2 = 0; i2 < s2.length() && s2.charAt(i2) == '\u00a7'; i2 += 2) {
        }
        if (i2 < s2.length()) {
            s1 = s2.substring(i2, i2 + 1);
        }
        return s1;
    }

    private static List format(String s2, int i2) {
        ArrayList<String> arraylist = new ArrayList<String>();
        if ((s2 = colorCrashFix.matcher(s2).replaceAll("")).length() == 0) {
            return arraylist;
        }
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        Stack<Character> stack = new Stack<Character>();
        Character character = new Character('f');
        stack.push(character);
        String[] as2 = s2.split("\n");
        StringBuilder stringbuilder = new StringBuilder().append(as2[0]);
        for (int i1 = 1; i1 < as2.length; ++i1) {
            if (ImprovedChat.m.q.a(String.valueOf(as2[i1 - 1]) + ImprovedChat.firstChar(as2[i1])) < 318) {
                stringbuilder.append('\n');
            }
            stringbuilder.append(as2[i1]);
        }
        s2 = stringbuilder.toString();
        stringbuilder = new StringBuilder();
        l2 = 0;
        k2 = 0;
        block7: for (j2 = 0; j2 < s2.length(); ++j2) {
            switch (s2.charAt(j2)) {
                case '\n': {
                    arraylist.add(colorCrashFix.matcher(stringbuilder.toString()).replaceAll(""));
                    stringbuilder.delete(0, stringbuilder.length()).append("\u00a7" + stack.peek());
                    l2 = 0;
                    k2 = 0;
                    continue block7;
                }
                case '\u00a7': {
                    stringbuilder.append(s2.substring(j2, j2 + 2));
                    stack.push(new Character(s2.charAt(++j2)));
                    continue block7;
                }
                case ' ': {
                    l2 = stringbuilder.length() + 1;
                    character = (Character)stack.peek();
                }
                case '/': {
                    if (s2.substring(j2).startsWith("/&c")) {
                        if (stack.size() > 1) {
                            stack.pop();
                        }
                        Character character1 = (Character)stack.peek();
                        stringbuilder.append("\u00a7" + character1);
                        j2 += 2;
                        continue block7;
                    }
                }
                default: {
                    String s1 = s2.substring(j2, j2 + 1);
                    int j1 = ImprovedChat.m.q.a(s1);
                    if (k2 + j1 > i2 && !s1.equals(" ")) {
                        if (l2 == 0) {
                            l2 = stringbuilder.length();
                            character = (Character)stack.peek();
                        }
                        arraylist.add(colorCrashFix.matcher(stringbuilder.substring(0, l2)).replaceAll(""));
                        stringbuilder.delete(0, l2).append(s1);
                        stringbuilder.insert(0, "\u00a7" + character);
                        k2 = ImprovedChat.m.q.a(stringbuilder.toString());
                        l2 = 0;
                        continue block7;
                    }
                    stringbuilder.append(s1);
                    k2 += j1;
                }
            }
        }
        arraylist.add(colorCrashFix.matcher(stringbuilder.toString()).replaceAll(""));
        return arraylist;
    }

    public static List processInput(String s2) {
        s2 = buxvillFix.matcher(s2).replaceAll("/&c");
        s2 = updateColor.matcher(d[0].process(s2)).replaceAll("\u00a7");
        return ImprovedChat.format(s2, 318);
    }

    public static String processOutput(String s2) {
        s2 = d[1].process(s2);
        s2 = ImprovedChat.replaceVars(s2);
        return colorTags.matcher(s2).replaceAll("");
    }

    public static List processDisplay(String s2) {
        s2 = updateColor.matcher(d[2].process(s2)).replaceAll("\u00a7");
        return ImprovedChat.format(s2, 316);
    }

    public static void keyPressed(int i2) {
        Integer integer;
        String s2;
        int j2 = 0;
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            ++j2;
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            j2 += 2;
        }
        if ((s2 = (String)ImprovedChat.Current.bindings[j2].get(integer = new Integer(i2))) == null) {
            s2 = (String)ImprovedChat.Global.bindings[j2].get(integer);
        }
        if (s2 != null) {
            if (s2.endsWith("\\")) {
                gc guichat = new gc();
                guichat.a = ImprovedChat.replaceVarsInBind(s2.substring(0, s2.length() - 1));
                guichat.cursorPosition = guichat.a.length();
                m.a(guichat);
            } else {
                ImprovedChat.process(s2);
            }
        }
    }

    public static String replaceVars(String s2) {
        Matcher matcher = varP.matcher(s2);
        StringBuilder stringbuilder = new StringBuilder();
        int i2 = 0;
        while (matcher.find()) {
            String s1 = ImprovedChat.getVar(s2.substring(matcher.start() + 1, matcher.end()));
            if (s1 == null) continue;
            stringbuilder.append(s2.substring(i2, matcher.start()));
            i2 = matcher.end();
            stringbuilder.append(s1);
        }
        stringbuilder.append(s2.substring(i2));
        return stringbuilder.toString();
    }

    public static String replaceVarsInBind(String s2) {
        Matcher matcher = varPinB.matcher(s2);
        StringBuilder stringbuilder = new StringBuilder();
        int i2 = 0;
        while (matcher.find()) {
            String s1 = ImprovedChat.getVar(s2.substring(matcher.start() + 2, matcher.end() - 1));
            if (s1 == null) continue;
            stringbuilder.append(s2.substring(i2, matcher.start()));
            i2 = matcher.end();
            stringbuilder.append(s1);
        }
        stringbuilder.append(s2.substring(i2));
        return stringbuilder.toString();
    }

    public static String fixInvalidCharacter(String s2) {
        return fixInvalidCharacter.matcher(s2).replaceAll("&c");
    }

    public static void listConstants() {
        Enumeration enumeration = constantVar.keys();
        while (enumeration.hasMoreElements()) {
            String s2 = (String)enumeration.nextElement();
            ImprovedChat.unProccessedInput(String.valueOf(s2) + ":" + (String)constantVar.get(s2));
        }
    }

    public static void send(String s2) {
        if ((s2 = s2.trim()).length() == 0) {
            return;
        }
        s2 = ImprovedChat.processOutput(s2);
        while (s2.length() > 100) {
            ImprovedChat.m.h.a(s2.substring(0, 100));
            s2 = s2.substring(100);
        }
        ImprovedChat.m.h.a(s2);
    }

    public static void console(String s2) {
        if (s2 == null || s2.trim().equals("")) {
            return;
        }
        List list1 = ImprovedChat.processInput(s2);
        String s1 = colorTags.matcher("~" + s2).replaceAll("");
        if (!Current.currentTab().ignored(s1)) {
            for (String s22 : list1) {
                Current.currentTab().add(s22);
            }
        }
    }

    public static void unProccessedInput(String s2) {
        if (s2 == null || s2.trim().equals("")) {
            return;
        }
        String s1 = colorTags.matcher("~" + s2).replaceAll("");
        if (Current.currentTab().ignored(s1)) {
            return;
        }
        List list1 = ImprovedChat.format(s2, 320);
        for (String s22 : list1) {
            Current.currentTab().add(s22);
        }
    }

    public static void stdout(String s2) {
        if (s2 == null || s2.trim().equals("")) {
            return;
        }
        List list1 = ImprovedChat.processInput(s2);
        sw[] achatline = new sw[list1.size()];
        for (int i2 = 0; i2 < achatline.length; ++i2) {
            achatline[i2] = new sw((String)list1.get(i2));
        }
        String s1 = colorTags.matcher(s2).replaceAll("");
        for (TabIMC tabIMC : ImprovedChat.Current.tabs) {
            if (!tabIMC.valid(s1)) continue;
            sw[] achatline1 = achatline;
            int k2 = achatline.length;
            for (int j2 = 0; j2 < k2; ++j2) {
                sw chatline = achatline1[j2];
                tabIMC.add(chatline);
            }
            List list2 = tabIMC.e;
            while (list2.size() > 300) {
                list2.remove(list2.size() - 1);
            }
        }
        TabIMC tabIMC1 = (TabIMC)ImprovedChat.Current.tabs.get(ImprovedChat.Current.currentTabIndex);
        tabIMC1.blinking = false;
        if (ImprovedChat.m.r instanceof gg && tabIMC1.chatScroll > 0 && tabIMC1.valid(s1)) {
            tabIMC1.chatScroll += list1.size();
            if (tabIMC1.chatScroll > tabIMC1.e.size() - 9) {
                tabIMC1.chatScroll = tabIMC1.e.size() - 9;
            }
            if (tabIMC1.chatScroll < 0) {
                tabIMC1.chatScroll = 0;
            }
        }
    }

    public static void stderr(String s2) {
        if (s2 == null || s2.trim().equals("")) {
            return;
        }
        ImprovedChat.console("\u00a74ERROR:\u00a7f " + s2);
    }

    private static String unsplit(String[] as2, int i2) {
        StringBuilder stringbuilder = new StringBuilder();
        if (i2 >= as2.length) {
            return "";
        }
        stringbuilder.append(as2[i2]);
        for (int j2 = i2 + 1; j2 < as2.length; ++j2) {
            stringbuilder.append(" ").append(as2[j2]);
        }
        return stringbuilder.toString();
    }

    private static String unsplit(String[] as2, int i2, int j2) {
        StringBuilder stringbuilder = new StringBuilder();
        if (i2 >= as2.length) {
            return "";
        }
        stringbuilder.append(as2[i2]);
        for (int k2 = i2 + 1; k2 < as2.length && k2 < j2; ++k2) {
            stringbuilder.append(" ").append(as2[k2]);
        }
        return stringbuilder.toString();
    }

    public ImprovedChat() {
        minecraftDir = Minecraft.a("minecraft");
        modDir = new File(minecraftDir, "mods" + File.separator + "wd1966");
        settings = new File(modDir, "ImprovedChat.xml");
        constantsFile = new File(modDir, "constants.txt");
        colors = new File(modDir, "colors.txt");
        if (!settings.exists()) {
            ImprovedChat.versionConvert();
        }
        if (!colors.exists()) {
            ImprovedChat.createColorFile();
        }
        d = new PatternList[3];
        ImprovedChat.d[0] = new PatternList();
        ImprovedChat.d[1] = new PatternList();
        ImprovedChat.d[2] = new PatternList();
        constantVar = new Hashtable();
        try {
            String s2;
            BufferedReader bufferedreader = new BufferedReader(new FileReader(colors));
            while ((s2 = bufferedreader.readLine()) != null) {
                s2 = s2.split("#", 2)[0].toLowerCase();
                String[] as2 = s2.split(":", 2);
                try {
                    int i2 = as2[1].startsWith("0x") ? Integer.parseInt(as2[1].substring(2), 16) : Integer.parseInt(as2[1]);
                    colorHex.put(as2[0], i2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            bufferedreader.close();
        }
        catch (FileNotFoundException filenotfoundexception) {
            filenotfoundexception.printStackTrace();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        commands = new Hashtable();
        commands.put("bind", new Command("binds a command to a key.", "bind <keyName> <command>", "Key binding succesfull"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 2) {
                    return false;
                }
                ImprovedChat.addKB(as1[0], ImprovedChat.unsplit(as1, 1));
                return true;
            }
        });
        commands.put("bgcolor", new Command("changes the backround color of the chat box.", "~bgColor <colorName>", "Background color of the chat bar successfully changed"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                int j2 = ImprovedChat.getColorHex(as1[0].toLowerCase());
                if (j2 == -1) {
                    bgColor = 0;
                    ImprovedChat.stderr("Color " + as1[0] + " not defined,");
                } else {
                    bgColor = j2;
                }
                return true;
            }
        });
        commands.put("bgopacity", new Command("changes the opacity of the chat box.", "~bgOpacity <num>", "Opacity of the chat bar successfully changed"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                if (!ImprovedChat.isNumeric(as1[0])) {
                    return false;
                }
                int j2 = Integer.parseInt(as1[0]);
                if (j2 < 0 || j2 > 100) {
                    ImprovedChat.stderr("Opacity must be between 0 and 100.");
                } else {
                    bgOpacity = (int)((double)j2 * 2.55);
                }
                return true;
            }
        });
        commands.put("histcolor", new Command("changes the backround color of the chat history.", "~histColor <colorName>", "Background color of the chat history successfully changed"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                int j2 = ImprovedChat.getColorHex(as1[0].toLowerCase());
                if (j2 == -1) {
                    bgColor = 0;
                    ImprovedChat.stderr("Color " + as1[0] + " not defined,");
                } else {
                    historyColor = j2;
                }
                return true;
            }
        });
        commands.put("histopacity", new Command("changes the opacity of the chat history.", "~histOpacity <num>", "Opacity of the chat history successfully changed"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                if (!ImprovedChat.isNumeric(as1[0])) {
                    return false;
                }
                int j2 = Integer.parseInt(as1[0]);
                if (j2 < 0 || j2 > 100) {
                    ImprovedChat.stderr("Opacity must be between 0 and 100.");
                } else {
                    historyOpacity = (int)((double)j2 * 2.55);
                }
                return true;
            }
        });
        commands.put("stop", new Command("Stops the chatting", null, ""){

            @Override
            public boolean process(String[] as1) {
                chatDisabled = true;
                return true;
            }
        });
        commands.put("start", new Command("Starts the chatting", null, ""){

            @Override
            public boolean process(String[] as1) {
                chatDisabled = false;
                return true;
            }
        });
        commands.put("help", new Command("Displays this message", null, ""){

            @Override
            public boolean process(String[] as1) {
                Enumeration enumeration = commands.keys();
                while (enumeration.hasMoreElements()) {
                    String s1 = (String)enumeration.nextElement();
                    ImprovedChat.console(String.valueOf(s1) + ":" + ((Command)commands.get(s1)).desc);
                }
                return true;
            }
        });
        commands.put("list", new Command("Lists variables, constants and rules(input, output or display)", "~list (bind|var|const|input|output|display|track|ignore)", ""){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                if (as1[0].equalsIgnoreCase("bind")) {
                    ImprovedChat.listKB();
                } else if (as1[0].equalsIgnoreCase("var")) {
                    ImprovedChat.listVars();
                } else if (as1[0].equalsIgnoreCase("const")) {
                    ImprovedChat.listConstants();
                } else if (as1[0].equalsIgnoreCase("track") || as1[0].equalsIgnoreCase("ignore")) {
                    ImprovedChat.unProccessedInput(String.valueOf(as1[0]) + " rule list:");
                    ArrayList arraylist = as1[0].equals("ignore") ? ((TabIMC)ImprovedChat.Current.tabs.get((int)ImprovedChat.Current.currentTabIndex)).ignore : ((TabIMC)ImprovedChat.Current.tabs.get((int)ImprovedChat.Current.currentTabIndex)).track;
                    if (arraylist.size() == 0) {
                        ImprovedChat.unProccessedInput("Empty");
                    }
                    for (Pattern pattern : arraylist) {
                        ImprovedChat.unProccessedInput(pattern.toString());
                    }
                } else {
                    return ImprovedChat.list(as1[0].toLowerCase());
                }
                return true;
            }
        });
        commands.put("move", new Command("Changes rules priority or moves tab position", "~move (input|output|display|tab) <from> <to>", ""){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 3) {
                    return false;
                }
                if (!ImprovedChat.isNumeric(as1[1])) {
                    return false;
                }
                int j2 = Integer.parseInt(as1[1]);
                if (!ImprovedChat.isNumeric(as1[2])) {
                    return false;
                }
                int k2 = Integer.parseInt(as1[2]);
                if (as1[0].equalsIgnoreCase("tab")) {
                    if (j2 < 0 || k2 < 0 || j2 >= ImprovedChat.Current.tabs.size() || k2 >= ImprovedChat.Current.tabs.size()) {
                        ImprovedChat.stderr("Index out of range");
                        return false;
                    }
                    ImprovedChat.Current.tabs.add(k2, (TabIMC)ImprovedChat.Current.tabs.remove(j2));
                    return true;
                }
                return ImprovedChat.moveRule(as1[0], j2, k2);
            }
        });
        commands.put("clear", new Command("Clears chat history.", null, ""){

            @Override
            public boolean process(String[] as1) {
                ((TabIMC)ImprovedChat.Current.tabs.get((int)ImprovedChat.Current.currentTabIndex)).e.clear();
                return true;
            }
        });
        commands.put("var", new Command("used for creating variables", "~var <varName> <regex>", "Variable created"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 2) {
                    return false;
                }
                return ImprovedChat.Current.vars.add(as1[0], ImprovedChat.unsplit(as1, 1));
            }
        });
        commands.put("reload", new Command("reloads config", null, "Config reloaded"){

            @Override
            public boolean process(String[] as1) {
                ImprovedChat.load();
                ImprovedChat.setWorld();
                return true;
            }
        });
        commands.put("delete", new Command("deletes variables, binds or rules", "~delete (bind|var|input|output|display) <id>", ""){

            @Override
            public boolean process(String[] as1) {
                int j2;
                if (as1 == null || as1.length < 2) {
                    return false;
                }
                if (as1[0].equalsIgnoreCase("bind")) {
                    return ImprovedChat.removeKB(as1[1].toUpperCase());
                }
                if (as1[0].equalsIgnoreCase("var")) {
                    ImprovedChat.removeVar(as1[1]);
                }
                if (!ImprovedChat.isNumeric(as1[1]) || (j2 = Integer.parseInt(as1[1])) < 0) {
                    ImprovedChat.stderr("Second argument should be a nonegative number.");
                    return false;
                }
                if (as1[0].equalsIgnoreCase("track") || as1[0].equalsIgnoreCase("ignore")) {
                    ArrayList arraylist = as1[0].equals("ignore") ? ((TabIMC)ImprovedChat.Current.tabs.get((int)ImprovedChat.Current.currentTabIndex)).ignore : ((TabIMC)ImprovedChat.Current.tabs.get((int)ImprovedChat.Current.currentTabIndex)).track;
                    if (j2 >= arraylist.size()) {
                        ImprovedChat.stderr("Index out of bounds.");
                        return false;
                    }
                    arraylist.remove(j2);
                    return true;
                }
                ImprovedChat.removeRule(as1[0], j2);
                return true;
            }
        });
        commands.put("script", new Command("run scripts from desktop(D:), .minecraft folder(M:) or mod folder", "~script [D:|M:]<scriptName>", "Script executed"){

            @Override
            public boolean process(String[] as1) {
                File file;
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                String s1 = as1[0];
                if (s1.startsWith("D:")) {
                    file = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "Desktop");
                    s1 = s1.substring(2);
                } else {
                    file = Minecraft.a("minecraft");
                    if (s1.startsWith("M:")) {
                        s1 = s1.substring(2);
                    } else {
                        file = new File(file, "mods" + File.separator + "wd1966");
                    }
                }
                File file1 = new File(file, s1);
                if (!file1.exists()) {
                    ImprovedChat.stderr("File " + as1[0] + " doesn't exist.");
                    return true;
                }
                try {
                    String s2;
                    BufferedReader bufferedreader1 = new BufferedReader(new FileReader(file1));
                    while ((s2 = bufferedreader1.readLine()) != null) {
                        if (s2.startsWith("#")) continue;
                        StringBuffer stringbuffer = new StringBuffer();
                        Matcher matcher = scriptVar.matcher(s2);
                        while (matcher.find()) {
                            int j2 = Integer.parseInt(matcher.group().substring(1));
                            if (j2 < 0 || j2 >= as1.length) continue;
                            matcher.appendReplacement(stringbuffer, as1[j2]);
                        }
                        matcher.appendTail(stringbuffer);
                        ImprovedChat.process(stringbuffer.toString());
                    }
                    bufferedreader1.close();
                }
                catch (FileNotFoundException filenotfoundexception1) {
                    filenotfoundexception1.printStackTrace();
                    return false;
                }
                catch (IOException ioexception1) {
                    ioexception1.printStackTrace();
                    return false;
                }
                return true;
            }
        });
        commands.put("input", new Command("makes rules for formating input window", "~input <regex>  <repl>", "Input rule created"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 3) {
                    return false;
                }
                for (int j2 = 1; j2 < as1.length; ++j2) {
                    if (!as1[j2].equals("")) continue;
                    ImprovedChat.addRule("input", ImprovedChat.unsplit(as1, 0, j2), ImprovedChat.unsplit(as1, j2 + 1));
                    return true;
                }
                return false;
            }
        });
        commands.put("output", new Command("makes rules for formating output messages", "~output <regex>  <repl>", "Output rule created"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 3) {
                    return false;
                }
                for (int j2 = 1; j2 < as1.length; ++j2) {
                    if (!as1[j2].equals("")) continue;
                    ImprovedChat.addRule("output", ImprovedChat.unsplit(as1, 0, j2), ImprovedChat.unsplit(as1, j2 + 1));
                    return true;
                }
                return false;
            }
        });
        commands.put("display", new Command("makes rules for formating chat box", "~display <regex>  <repl>", "Display rule created"){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 3) {
                    return false;
                }
                for (int j2 = 1; j2 < as1.length; ++j2) {
                    if (!as1[j2].equals("")) continue;
                    ImprovedChat.addRule("display", ImprovedChat.unsplit(as1, 0, j2), ImprovedChat.unsplit(as1, j2 + 1));
                    return true;
                }
                return false;
            }
        });
        commands.put("close", new Command("Used for closing the curent tab", "~close", ""){

            @Override
            public boolean process(String[] as1) {
                if (ImprovedChat.Current.tabs.size() < 2) {
                    ImprovedChat.stderr("Can not remove only tab.");
                    return false;
                }
                ImprovedChat.Current.tabs.remove(ImprovedChat.Current.currentTabIndex);
                if (ImprovedChat.Current.currentTabIndex >= ImprovedChat.Current.tabs.size()) {
                    ImprovedChat.Current.currentTabIndex = ImprovedChat.Current.tabs.size() - 1;
                }
                ImprovedChat.console("Tab removed.");
                return true;
            }
        });
        commands.put("blink", new Command("Blink on new messages", "~blink (on|off)", ""){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                ImprovedChat.Current.currentTab().blink = as1[0].equalsIgnoreCase("on");
                return true;
            }
        });
        commands.put("track", new Command("Includes all the messages of given format into this tab", "~track <regex>", ""){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                String s1 = ImprovedChat.unsplit(as1, 0);
                Current.currentTab().track(s1);
                return true;
            }
        });
        commands.put("ignore", new Command("Excludes all the messages of given format from this tab", "~ignore <regex>", ""){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                String s1 = ImprovedChat.unsplit(as1, 0);
                Current.currentTab().ignore(s1);
                return true;
            }
        });
        commands.put("prefix", new Command("All messages sent in this tab will start with this prefix", "~prefix <prefix>", ""){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                ImprovedChat.Current.currentTab().prefix = ImprovedChat.unsplit(as1, 0);
                return true;
            }
        });
        commands.put("tab", new Command("Used for creating and renameing tabs.", "~tab [name] <name>", ""){

            @Override
            public boolean process(String[] as1) {
                if (as1 == null || as1.length < 1) {
                    return false;
                }
                if (as1[0].equalsIgnoreCase("name")) {
                    if (as1.length < 2) {
                        ImprovedChat.console("Missing parametar.");
                        return false;
                    }
                    Current.currentTab().setName(ImprovedChat.unsplit(as1, 1));
                    return true;
                }
                ImprovedChat.Current.tabs.add(new TabIMC(ImprovedChat.unsplit(as1, 0)));
                ImprovedChat.Current.currentTabIndex = ImprovedChat.Current.tabs.size() - 1;
                ImprovedChat.console("Tab created.");
                return true;
            }
        });
        ImprovedChat.load();
        if (Global == null) {
            Global = new Server("Global", "");
            TabIMC tabIMC = new TabIMC("Default");
            ImprovedChat.Global.tabs.add(tabIMC);
            tabIMC.track("^");
        }
        Current = Global;
    }

    public static void process(String s2) {
        if (s2 == null || s2.trim().equals("")) {
            return;
        }
        if (!s2.startsWith("~") && !s2.startsWith("/")) {
            s2 = String.valueOf(((TabIMC)ImprovedChat.Current.tabs.get((int)ImprovedChat.Current.currentTabIndex)).prefix) + s2;
        }
        ImprovedChat.send(s2);
    }

    public static void exec(String s2) {
        Command command;
        if (s2.startsWith("(")) {
            int i2;
            StringBuilder stringbuilder = new StringBuilder();
            block4: for (i2 = 1; i2 < s2.length(); ++i2) {
                char c2 = s2.charAt(i2);
                switch (c2) {
                    case ')': {
                        break block4;
                    }
                    case '\\': {
                        if (i2 + 1 < s2.length() && s2.charAt(i2 + 1) == ')') {
                            stringbuilder.append(')');
                            ++i2;
                            continue block4;
                        }
                    }
                    default: {
                        stringbuilder.append(c2);
                    }
                }
            }
            s2 = s2.substring(i2 + 1);
            String s1 = stringbuilder.toString();
            int j2 = 100 - s1.length();
            if (j2 <= 0) {
                ImprovedChat.stderr("Prefix is too long");
                return;
            }
            while (s2.length() > j2) {
                ImprovedChat.m.h.a(String.valueOf(s1) + s2.substring(0, j2));
                s2 = s2.substring(j2);
            }
            ImprovedChat.m.h.a(String.valueOf(s1) + s2);
            return;
        }
        String[] as2 = space.split(s2, 2);
        Server server = Current;
        if (as2.length == 2 && as2[0].equalsIgnoreCase("global")) {
            Current = Global;
            as2 = space.split(as2[1], 2);
        }
        if ((command = (Command)commands.get(as2[0].toLowerCase())) == null) {
            ImprovedChat.console("Command " + as2[0] + " doesn't exist.");
            return;
        }
        if (command.process(as2 = as2.length != 2 ? (String[])null : space.split(as2[1], -1))) {
            ImprovedChat.console(command.success);
        } else {
            ImprovedChat.console("Description: " + command.desc);
            ImprovedChat.console("Usage: " + command.usage);
        }
        Current = server;
        ImprovedChat.save();
    }

    public static boolean isNumeric(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (s2.charAt(i2) >= '0' && s2.charAt(i2) <= '9') continue;
            return false;
        }
        return true;
    }

    public static void receiveLine(String s2) {
        if (chatDisabled) {
            return;
        }
        ImprovedChat.varProcess(s2);
        ImprovedChat.stdout(s2);
    }

    public static void setWorld() {
        String s2 = ImprovedChat.m.z.C;
        Current = (Server)servers.get(s2);
        if (Current == null) {
            Current = new Server(s2);
            servers.put(s2, Current);
        }
    }

    public static TabIMC currentTab() {
        return Current.currentTab();
    }

    public static void tick() {
        if (Current != null) {
            for (int i2 = 0; i2 < ImprovedChat.currentTab().e.size(); ++i2) {
                ++((sw)ImprovedChat.currentTab().e.get((int)i2)).b;
            }
        }
    }

    public static String getServer(int i2) {
        if (i2 > servers.size()) {
            return null;
        }
        Enumeration enumeration = servers.keys();
        String s2 = null;
        while (i2-- > 0 && enumeration.hasMoreElements()) {
            s2 = (String)enumeration.nextElement();
        }
        return s2;
    }

    public static String getServerAddress(String s2) {
        return ((Server)ImprovedChat.servers.get((Object)s2)).address;
    }

    public static void copy(String s2) {
        clipboard.setContents(new StringSelection(s2), null);
    }

    public static String paste() {
        String s2 = "";
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                s2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return s2;
    }

    static {
        servers = new Hashtable();
        pastCommands = new ArrayList();
        space = Pattern.compile(" ");
        colorHex = new Hashtable();
        chatDisabled = false;
        bgOpacity = 128;
        bgColor = 0;
        historyOpacity = 128;
        historyColor = 0;
        colorCrashFix = Pattern.compile("\u00a7(?![0-9a-fA-F])|\u00a7[0-9a-fA-F]?$");
        colorTags = Pattern.compile("(\u00a7|&c)[0-9a-fA-F]|/&c");
        updateColor = Pattern.compile("(?<!/)&c(?=[0-9a-fA-F])");
        buxvillFix = Pattern.compile("\u00a7\u00a7");
        varP = Pattern.compile("\\$\\w*");
        varPinB = Pattern.compile("'\\$\\w*'");
        fixInvalidCharacter = Pattern.compile("\u00a7");
        scriptVar = Pattern.compile("\\$[0-9]+");
        clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    private abstract class Command {
        private String usage;
        private String desc;
        private String success;

        public abstract boolean process(String[] var1);

        public Command(String s2, String s1, String s22) {
            this.desc = s2;
            this.usage = s1;
            this.success = s22;
        }
    }
}

