/*
 * Decompiled with CFR 0.152.
 */
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiList {
    public final Minecraft mc;
    private final int left = 0;
    private final int right;
    protected final int width;
    protected final int height;
    protected final int top;
    protected final int bottom;
    protected final int slotHeight;
    protected float amountScrolled = 0.0f;
    protected float scrollMultiplier;
    private boolean drag;
    private float dragY = 0.0f;

    public GuiList(Minecraft mc2, int width, int height, int top, int bottom, int slotHeight) {
        this.mc = mc2;
        this.height = height;
        this.width = width;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = slotHeight;
        this.right = width;
    }

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    public abstract int getSize();

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (mouseY > this.top && mouseY < this.bottom) {
            this.drag = true;
            this.dragY = mouseY;
            int listRight = this.width / 2 + 124;
            int scrollRight = listRight + 6;
            if (mouseX >= listRight && mouseX <= scrollRight) {
                int i4;
                this.scrollMultiplier = -1.0f;
                int contentHeight = this.getContentHeight() - (this.bottom - this.top - 4);
                if (contentHeight < 1) {
                    contentHeight = 1;
                }
                if ((i4 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                    i4 = 32;
                }
                if (i4 > this.bottom - this.top - 8) {
                    i4 = this.bottom - this.top - 8;
                }
                this.scrollMultiplier /= (float)(this.bottom - this.top - i4) / (float)contentHeight;
            } else {
                this.scrollMultiplier = 1.0f;
            }
        }
    }

    public void mouseMovedOrUp(int mouseX, int mouseY, int button) {
        if (this.drag) {
            if (this.mc.z.swappedMouseButtonsInGui) {
                if (button < 0) {
                    if (Mouse.isButtonDown((int)1)) {
                        this.updateScrolled(0.0f - ((float)mouseY - this.dragY) * this.scrollMultiplier);
                        this.dragY = mouseY;
                    }
                } else if (button == 1) {
                    this.drag = false;
                }
            } else if (button < 0) {
                if (Mouse.isButtonDown((int)0)) {
                    this.updateScrolled(0.0f - ((float)mouseY - this.dragY) * this.scrollMultiplier);
                    this.dragY = mouseY;
                }
            } else if (button == 0) {
                this.drag = false;
            }
        }
    }

    public void mouseScrolled(int amount) {
        if (amount > 0) {
            amount = -1;
        } else if (amount < 0) {
            amount = 1;
        }
        this.updateScrolled(amount * this.slotHeight / 2);
    }

    public void updateScrolled(float amount) {
        int i2 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (i2 < 0) {
            i2 /= 2;
        }
        this.amountScrolled += amount;
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        } else if (this.amountScrolled > (float)i2) {
            this.amountScrolled = i2;
        }
    }

    public abstract void keyTyped(char var1, int var2);

    public abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, nw var6);

    public void drawScreen(int mouseX, int mouseY, float f2) {
        int size = this.getSize();
        int l2 = this.width / 2 + 124;
        int i1 = l2 + 6;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        nw tessellator = nw.a;
        GL11.glBindTexture((int)3553, (int)this.mc.p.b("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 32.0f;
        qq scaledresolution = new qq(1, this.mc.d, this.mc.e);
        if (!this.mc.gsh.shouldBeShader) {
            tessellator.b();
            tessellator.b(0x202020);
            tessellator.a(0.0, this.bottom, 0.0, 0.0f / f1, (float)(this.bottom + (int)this.amountScrolled) / f1);
            tessellator.a(this.right, this.bottom, 0.0, (float)this.right / f1, (float)(this.bottom + (int)this.amountScrolled) / f1);
            tessellator.a(this.right, this.top, 0.0, (float)this.right / f1, (float)(this.top + (int)this.amountScrolled) / f1);
            tessellator.a(0.0, this.top, 0.0, 0.0f / f1, (float)(this.top + (int)this.amountScrolled) / f1);
            tessellator.a();
        }
        int i2 = this.width / 2 - 92 - 16;
        int k2 = this.top + 4 - (int)this.amountScrolled;
        for (int i3 = 0; i3 < size; ++i3) {
            int k3 = k2 + i3 * this.slotHeight;
            int j4 = this.slotHeight - 4;
            if (k3 > this.bottom || k3 + j4 < this.top) continue;
            this.drawSlot(i3, i2, k3, mouseX, mouseY, tessellator);
        }
        GL11.glDisable((int)2929);
        int byte0 = 4;
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tessellator.b();
        tessellator.a(0, 0);
        tessellator.a(0.0, this.top + byte0, 0.0, 0.0, 1.0);
        tessellator.a(this.right, this.top + byte0, 0.0, 1.0, 1.0);
        tessellator.a(0, 255);
        tessellator.a(this.right, this.top, 0.0, 1.0, 0.0);
        tessellator.a(0.0, this.top, 0.0, 0.0, 0.0);
        tessellator.a();
        tessellator.b();
        tessellator.a(0, 255);
        tessellator.a(0.0, this.bottom, 0.0, 0.0, 1.0);
        tessellator.a(this.right, this.bottom, 0.0, 1.0, 1.0);
        tessellator.a(0, 0);
        tessellator.a(this.right, this.bottom - byte0, 0.0, 1.0, 0.0);
        tessellator.a(0.0, this.bottom - byte0, 0.0, 0.0, 0.0);
        tessellator.a();
        int contentHeight = this.getContentHeight() - (this.bottom - this.top - 4);
        if (contentHeight > 0) {
            int i5;
            int k4 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (k4 < 32) {
                k4 = 32;
            }
            if (k4 > this.bottom - this.top - 8) {
                k4 = this.bottom - this.top - 8;
            }
            if ((i5 = (int)this.amountScrolled * (this.bottom - this.top - k4) / contentHeight + this.top) < this.top) {
                i5 = this.top;
            }
            tessellator.b();
            tessellator.a(0, 255);
            tessellator.a(l2, this.bottom, 0.0, 0.0, 1.0);
            tessellator.a(i1, this.bottom, 0.0, 1.0, 1.0);
            tessellator.a(i1, this.top, 0.0, 1.0, 0.0);
            tessellator.a(l2, this.top, 0.0, 0.0, 0.0);
            tessellator.a();
            tessellator.b();
            tessellator.a(0x808080, 255);
            tessellator.a(l2, i5 + k4, 0.0, 0.0, 1.0);
            tessellator.a(i1, i5 + k4, 0.0, 1.0, 1.0);
            tessellator.a(i1, i5, 0.0, 1.0, 0.0);
            tessellator.a(l2, i5, 0.0, 0.0, 0.0);
            tessellator.a();
            tessellator.b();
            tessellator.a(0xC0C0C0, 255);
            tessellator.a(l2, i5 + k4 - 1, 0.0, 0.0, 1.0);
            tessellator.a(i1 - 1, i5 + k4 - 1, 0.0, 1.0, 1.0);
            tessellator.a(i1 - 1, i5, 0.0, 1.0, 0.0);
            tessellator.a(l2, i5, 0.0, 0.0, 0.0);
            tessellator.a();
        }
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    protected void drawGradientRect(int i2, int j2, int k2, int l2, int i1, int j1) {
        float f2 = (float)(i1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(i1 >> 16 & 0xFF) / 255.0f;
        float f22 = (float)(i1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(i1 & 0xFF) / 255.0f;
        float f4 = (float)(j1 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(j1 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(j1 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(j1 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        nw tessellator = nw.a;
        tessellator.b();
        tessellator.a(f1, f22, f3, f2);
        tessellator.a((double)k2, (double)j2, 0.0);
        tessellator.a((double)i2, (double)j2, 0.0);
        tessellator.a(f5, f6, f7, f4);
        tessellator.a((double)i2, (double)l2, 0.0);
        tessellator.a((double)k2, (double)l2, 0.0);
        tessellator.a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    private void overlayBackground(int top, int bottom, int k2, int l2) {
        nw tessellator = nw.a;
        GL11.glBindTexture((int)3553, (int)this.mc.p.b("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f2 = 32.0f;
        tessellator.b();
        tessellator.a(0x404040, l2);
        tessellator.a(0.0, bottom, 0.0, 0.0, (float)bottom / f2);
        tessellator.a(this.width, bottom, 0.0, (float)this.width / f2, (float)bottom / f2);
        tessellator.a(0x404040, k2);
        tessellator.a(this.width, top, 0.0, (float)this.width / f2, (float)top / f2);
        tessellator.a(0.0, top, 0.0, 0.0, (float)top / f2);
        tessellator.a();
    }
}

